/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.Message;

public class COTPositionRequest
extends Message {
    private static final long serialVersionUID = 100014L;
    public static final int COT_POSITION = 1;
    public static final int COT_CLEAR = 2;
    protected int requestType;
    protected String client;
    public static final String TAG_requestType = "RTY";
    public static final String TAG_client = "CLT";

    public COTPositionRequest(int reqType, String client) {
        super(315);
        this.setRequestType(reqType);
        this.setClient(client);
    }

    public COTPositionRequest() {
        super(315);
    }

    public void setRequestType(int reqType) {
        if (reqType != 1 && reqType != 2) {
            throw new IllegalArgumentException("Invalid COT Position Request Type");
        }
        this.requestType = reqType;
    }

    public void setClient(String cl) {
        this.client = cl;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public String getClient() {
        return this.client;
    }

    public String formatString() {
        return "";
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"COTPositionRequest\">");
        xml.append("<RTY>" + this.requestType + "</" + TAG_requestType + ">");
        if (this.client != null && !this.client.equals("")) {
            xml.append("<CLT><![CDATA[" + this.client + "]]>" + "</" + TAG_client + ">");
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

