/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.COTOrderData;
import pk.com.softech.messages.Message;

public class COTOrderResponse
extends Message {
    private static final long serialVersionUID = 100013L;
    protected COTOrderData[] rows = null;
    protected int filled;
    protected String remarks = "";
    public static final String TAG_filled = "FLD";
    public static final String TAG_remarks = "REM";
    public static final String TAG_rows = "ROW";

    public COTOrderResponse(COTOrderData[] rws, String rem) {
        super(0);
        this.filled = 0;
        if (rws != null) {
            this.rows = new COTOrderData[rws.length];
            System.arraycopy(rws, 0, this.rows, 0, rws.length);
            this.filled = rws.length;
        }
        this.remarks = rem;
    }

    public COTOrderResponse(int size) {
        super(0);
        this.rows = new COTOrderData[size];
        this.filled = 0;
    }

    public void setRemarks(String rem) {
        this.remarks = rem;
    }

    public void addCOTOrder(COTOrderData data) throws ArrayIndexOutOfBoundsException {
        this.rows[this.filled++] = data;
    }

    public COTOrderData[] getRows() {
        return this.rows;
    }

    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"ClearingTypeResponse\"><FLD>" + this.filled + "</" + TAG_filled + ">");
        if (this.remarks != null && !this.remarks.equals("")) {
            xml.append("<REM><![CDATA[" + this.remarks + "]]>" + "</" + TAG_remarks + ">");
        }
        int i = 0;
        while (i < this.filled) {
            if (this.rows[i] != null) {
                xml.append("<ROW>" + this.rows[i].toXML() + "</" + TAG_rows + ">");
            }
            ++i;
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

