/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.COTInvestorData;
import pk.com.softech.messages.Message;

public class COTInvestorResponse
extends Message {
    protected COTInvestorData[] rows = null;
    protected int filled;
    protected String remarks = "";
    public static final String TAG_filled = "FLD";
    public static final String TAG_remarks = "REM";
    public static final String TAG_rows = "ROW";
    private boolean limit = false;
    private float price;

    public COTInvestorResponse(COTInvestorData[] rws, String rem) {
        super(0);
        this.filled = 0;
        if (rws != null) {
            this.rows = new COTInvestorData[rws.length];
            System.arraycopy(rws, 0, this.rows, 0, rws.length);
            this.filled = rws.length;
        }
        this.remarks = rem;
    }

    public COTInvestorResponse(int size) {
        super(0);
        this.rows = new COTInvestorData[size];
        this.filled = 0;
    }

    public void setRemarks(String rem) {
        this.remarks = rem;
    }

    public void addCOTOrder(COTInvestorData data) throws ArrayIndexOutOfBoundsException {
        this.rows[this.filled++] = data;
    }

    public COTInvestorData[] getRows() {
        return this.rows;
    }

    public boolean isLimit() {
        return this.limit;
    }

    public void setLimit(boolean limit) {
        this.limit = limit;
    }

    public float getPrice() {
        return this.price;
    }

    public void setPrice(float price) {
        this.price = price;
    }

    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"COTInvestorResponse\"><FLD>" + this.filled + "</" + TAG_filled + ">");
        if (this.remarks != null && !this.remarks.equals("")) {
            xml.append("<REM><![CDATA[" + this.remarks + "]]>" + "</" + TAG_remarks + ">");
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

