/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class COTData
implements Serializable {
    private static final long serialVersionUID = 100010L;
    private String symbol;
    private String client;
    private Date settlementDate;
    private int totalVolume = 0;
    private int deliveryVolume = 0;
    public static final String TAG_symbol = "SYM";
    public static final String TAG_client = "CLI";
    public static final String TAG_settlementDate = "STD";
    public static final String TAG_totalVolume = "TVL";
    public static final String TAG_deliveryVolume = "DVL";

    public COTData(String symbol, String client, Date settlementDate, int totalVol, int devVol) {
        this.setSymbol(symbol);
        this.setClient(client);
        this.setSettlementDate(settlementDate);
        this.setTotalVolume(totalVol);
        this.setDeliveryVolume(devVol);
    }

    public COTData() {
    }

    public void setSymbol(String sym) {
        this.symbol = sym;
    }

    public void setClient(String clt) {
        this.client = clt;
    }

    public void setSettlementDate(Date date) {
        this.settlementDate = new Date(date.getTime());
    }

    public void setTotalVolume(int volume) {
        this.totalVolume = volume;
    }

    public void setDeliveryVolume(int volume) {
        this.deliveryVolume = volume;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getClient() {
        return this.client;
    }

    public Date getSettlementDate() {
        return this.settlementDate;
    }

    public int getTotalVolume() {
        return this.totalVolume;
    }

    public int getDeliveryVolume() {
        return this.deliveryVolume;
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"COTData\">");
        if (this.symbol != null && !this.symbol.equals("")) {
            xml.append("<SYM><![CDATA[" + this.symbol + "]]>" + "</" + TAG_symbol + ">");
        }
        if (this.client != null && !this.client.equals("")) {
            xml.append("<CLI><![CDATA[" + this.client + "]]>" + "</" + TAG_client + ">");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setLenient(false);
        xml.append("<STD>" + dateFormat.format(this.settlementDate) + "</" + TAG_settlementDate + ">" + "<" + TAG_totalVolume + ">" + this.totalVolume + "</" + TAG_totalVolume + ">" + "<" + TAG_deliveryVolume + ">" + this.deliveryVolume + "</" + TAG_deliveryVolume + ">" + "</Class>");
        return xml.toString();
    }
}

