/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.util.Date;
import pk.com.softech.messages.Basket;
import pk.com.softech.messages.Message;

public class BasketStatusConfirmation
extends Message {
    private static final long serialVersionUID = 100152L;
    public static final int CREATED = 0;
    public static final int ACTIVE = 1;
    public static final int SUSPENDED = 2;
    public static final int EXECUTED = 3;
    public static final int CANCELLED = 4;
    public static final int REJECTED = 5;
    public static final int SAVED = 6;
    protected Basket basket;
    protected int action;
    protected String remarks;
    public static final String TAG_basket = "BAS";
    public static final String TAG_action = "ACT";
    public static final String TAG_remarks = "REM";

    public BasketStatusConfirmation(Basket basket, int action, String remarks) {
        super(120);
        this.setBasket(basket);
        this.setAction(action);
        this.setRemarks(remarks);
    }

    public BasketStatusConfirmation(Basket basket, int action, String remarks, Date timeStamp) {
        this(basket, action, remarks);
        this.setTimeStamp(timeStamp);
    }

    public BasketStatusConfirmation() {
        super(120);
    }

    public void setBasket(Basket basket) {
        this.basket = basket;
    }

    public Basket getBasket() {
        return this.basket;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setAction(int action) {
        if (action != 0 && action != 1 && action != 2 && action != 3 && action != 4 && action != 6 && action != 5) {
            throw new IllegalArgumentException();
        }
        this.action = action;
    }

    public int getAction() {
        return this.action;
    }

    public String buildMessage() {
        return this.getRemarks();
    }

    public String formatString() {
        return "OC|" + this.buildMessage();
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"BasketStatusConfirmation\">");
        if (this.basket != null) {
            xml.append("<BAS>" + this.basket.toXML() + "</" + TAG_basket + ">");
        }
        xml.append("<ACT>" + this.action + "</" + TAG_action + ">");
        if (this.remarks != null && !this.remarks.equals("")) {
            xml.append("<REM><![CDATA[" + this.remarks + "]]>" + "</" + TAG_remarks + ">");
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

