/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.io.Serializable;
import java.util.Date;
import pk.com.softech.messages.BasketDetail;
import pk.com.softech.messages.Message;

public class Basket
extends Message
implements Serializable {
    private static final long serialVersionUID = 100150L;
    public static final int NEW = 0;
    public static final int ACTIVE = 1;
    public static final int SUSPENDED = 2;
    public static final int EXECUTED = 3;
    public static final int CANCELLED = 4;
    public static final int MODIFIED = 5;
    public static final int REJECTED = 6;
    public static final String[] statusNames = new String[]{"New", "Active", "Suspended", "Executed", "Cancelled", "Rejected"};
    public static final int SQ = 0;
    public static final String[] typeNames = new String[]{"Sequential"};
    protected int basketId;
    protected int status;
    protected Date createdOn;
    protected String basketName;
    protected String stockExchange;
    protected String userId;
    protected String client;
    protected String memberId;
    protected String clientUIN;
    protected String traderCode;
    protected String basketType;
    protected String basketStatus;
    protected int afterHourOrder;
    BasketDetail[] orders;

    public Basket(int id, String name, String userId, String client, String memberId, String UIN, String traderCode, String exchange, Date createdOn, int status, BasketDetail[] orders) {
        this.setId(id);
        this.setTimeStamp(createdOn);
        this.setName(name);
        this.setTraderCode(traderCode);
        this.setExchange(exchange);
        this.setClient(client);
        this.setUserId(userId);
        this.setMemberId(memberId);
        this.setUIN(UIN);
        this.setStatus(status);
        this.setOrder(orders);
    }

    public Basket(int id, Date createdOn, String name, String exchange, String client, String UIN, String userId, String type, String status, BasketDetail[] orders) {
        this.setId(id);
        this.setTimeStamp(createdOn);
        this.setName(name);
        this.setExchange(exchange);
        this.setClient(client);
        this.setUIN(UIN);
        this.setUserId(userId);
        this.setBasketStatus(status);
        this.setBasketType(type);
        this.setOrder(orders);
    }

    public void setId(int id) {
        this.basketId = id;
    }

    public void setOrder(BasketDetail[] order) {
        this.orders = new BasketDetail[order.length];
        System.arraycopy(order, 0, this.orders, 0, order.length);
    }

    public void setAfterHourOrder(int afterHourOrder) {
        this.afterHourOrder = afterHourOrder;
    }

    @Override
    public void setTimeStamp(Date createdOn) {
        this.createdOn = createdOn;
    }

    public void setName(String name) {
        this.basketName = name;
    }

    public void setExchange(String exchange) {
        this.stockExchange = exchange;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public void setUIN(String UIN) {
        this.clientUIN = UIN;
    }

    public void setTraderCode(String traderCode) {
        this.traderCode = traderCode;
    }

    public void setBasketType(String type) {
        if (type.equals("SQ")) {
            this.basketType = typeNames[0];
        }
    }

    public void setBasketStatus(String status) {
        if (status.equals("NW")) {
            this.basketStatus = statusNames[0];
        } else if (status.equals("SP")) {
            this.basketStatus = statusNames[2];
        } else if (status.equals("EX")) {
            this.basketStatus = statusNames[3];
        } else if (status.equals("AC")) {
            this.basketStatus = statusNames[1];
        } else if (status.equals("CN")) {
            this.basketStatus = statusNames[4];
        } else if (status.equals("RJ")) {
            this.basketStatus = statusNames[6];
        }
    }

    public void setStatus(int status) {
        if (status != 0 && status != 1 && status != 2 && status != 3 && status != 4 && status != 5) {
            throw new IllegalArgumentException();
        }
        this.status = status;
    }

    public int getId() {
        return this.basketId;
    }

    @Override
    public Date getTimeStamp() {
        this.createdOn = this.createdOn;
        return this.createdOn;
    }

    public String getName() {
        return this.basketName;
    }

    public String getExchange() {
        return this.stockExchange;
    }

    public String getClient() {
        return this.client;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public String getUIN() {
        return this.clientUIN;
    }

    public String getTraderCode() {
        return this.traderCode;
    }

    public String getBasketType() {
        return this.basketType;
    }

    public String getBasketStatus() {
        return this.basketStatus;
    }

    public int getStatus() {
        return this.status;
    }

    public int getAfterHourOrder() {
        return this.afterHourOrder;
    }

    public BasketDetail[] getOrders() {
        return this.orders;
    }
}

