/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import java.util.Date;
import pk.com.softech.messages.Message;
import pk.com.softech.messages.OrderMessage;

public class BBManualClientRequest
extends Message {
    private static final long serialVersionUID = 100050L;
    public static final int NEW_ACCEPT = 0;
    public static final int NEW_REJECT = 1;
    public static final int MODIFY_ACCEPT = 2;
    public static final int MODIFY_REJECT = 3;
    public static final int CANCEL_ACCEPT = 4;
    public static final int CANCEL_REJECT = 5;
    public static final int PARTIAL_FILL_ACK = 6;
    public static final int FUILL_ACK = 7;
    public static final String[] statusNames = new String[]{"NEW_ACCEPT", "NEW_REJECT", "MODIFY_ACCEPT", "MODIFY_REJECT", "CANCEL_ACCEPT", "CANCEL_REJECT", "PARTIAL FILL ACK", "FILL ACK"};
    protected OrderMessage order;
    protected int action;
    protected String remarks;
    public static final String TAG_order = "ORD";
    public static final String TAG_action = "ACT";
    public static final String TAG_remarks = "REM";

    public BBManualClientRequest(OrderMessage order, int action, String remarks) {
        super(2003);
        this.setOrder(order);
        this.setAction(action);
        this.setRemarks(remarks);
    }

    public BBManualClientRequest(OrderMessage order, int action, String remarks, Date timeStamp) {
        this(order, action, remarks);
        this.setTimeStamp(timeStamp);
    }

    public BBManualClientRequest() {
        super(2003);
    }

    public void setOrder(OrderMessage order) {
        this.order = order;
    }

    public OrderMessage getOrder() {
        return this.order;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setAction(int action) {
        if (action != 0 && action != 1 && action != 2 && action != 3 && action != 4 && action != 5 && action != 6 && action != 7) {
            throw new IllegalArgumentException();
        }
        this.action = action;
    }

    public int getAction() {
        return this.action;
    }

    public String buildMessage() {
        return this.getRemarks();
    }

    public String formatString() {
        return "OC|" + this.buildMessage();
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"OrderConfirmation\">");
        if (this.order != null) {
            xml.append("<ORD>" + this.order.toXML() + "</" + TAG_order + ">");
        }
        xml.append("<ACT>" + this.action + "</" + TAG_action + ">");
        if (this.remarks != null && !this.remarks.equals("")) {
            xml.append("<REM><![CDATA[" + this.remarks + "]]>" + "</" + TAG_remarks + ">");
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

