/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.messages;

import pk.com.softech.messages.Message;
import pk.com.softech.messages.OrderData;

public class AHOrdersResponse
extends Message {
    private static final long serialVersionUID = 100097L;
    public static final int FETCH_ORDERS = 1;
    public static final int PLACE_ORDERS = 2;
    public static final int SUCCESSFUL = 1;
    public static final int FAILED = 2;
    protected int ordersResponseType;
    protected int action;
    protected String remarks;
    protected int filled;
    protected OrderData[] rows;
    public static final String TAG_ordersResponseType = "ORT";
    public static final String TAG_action = "ACT";
    public static final String TAG_remarks = "REM";
    public static final String TAG_filled = "FLD";
    public static final String TAG_rows = "ROW";

    public AHOrdersResponse(int responseType, int act, String rem) {
        super(0);
        this.setOrdersResponseType(responseType);
        this.setAction(act);
        this.setRemarks(rem);
        this.rows = null;
        this.filled = 0;
    }

    public AHOrdersResponse(int responseType, int act, String rem, OrderData[] rows) {
        super(0);
        this.setOrdersResponseType(responseType);
        this.setAction(act);
        this.setRemarks(rem);
        this.rows = new OrderData[rows.length];
        System.arraycopy(rows, 0, this.rows, 0, rows.length);
        this.filled = rows.length;
    }

    public AHOrdersResponse(int size) {
        super(0);
        this.rows = new OrderData[size];
        this.filled = 0;
    }

    public void setAction(int act) {
        switch (act) {
            case 1: 
            case 2: {
                this.action = act;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid after hour orders response action.");
            }
        }
    }

    public int getAction() {
        return this.action;
    }

    public void setRemarks(String rem) {
        this.remarks = rem;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setOrdersResponseType(int responseType) {
        switch (responseType) {
            case 1: 
            case 2: {
                this.ordersResponseType = responseType;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid after hour orders response type.");
            }
        }
    }

    public int getOrdersResponseType() {
        return this.ordersResponseType;
    }

    public void addOrderData(OrderData data) throws ArrayIndexOutOfBoundsException {
        this.rows[this.filled++] = data;
    }

    public OrderData[] getrows() {
        return this.rows;
    }

    @Override
    public String toXML() {
        StringBuffer xml = new StringBuffer("<Class name=\"AHOrdersResponse\"><FLD>" + this.filled + "</" + TAG_filled + ">" + "<" + TAG_ordersResponseType + ">" + this.ordersResponseType + "</" + TAG_ordersResponseType + ">" + "<" + TAG_action + ">" + this.action + "</" + TAG_action + ">");
        if (this.remarks != null && !this.remarks.equals("")) {
            xml.append("<REM><![CDATA[" + this.remarks + "]]>" + "</" + TAG_remarks + ">");
        }
        int i = 0;
        while (i < this.filled) {
            if (this.rows[i] != null) {
                xml.append("<ROW>" + this.rows[i].toXML() + "</" + TAG_rows + ">");
            }
            ++i;
        }
        xml.append("</Class>");
        return xml.toString();
    }
}

