/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.feed;

import org.eclipse.osgi.util.NLS;

public class TimeSpan {
    private Units units;
    private int length;

    public static TimeSpan minutes(int length) {
        return new TimeSpan(Units.Minutes, length);
    }

    public static TimeSpan days(int length) {
        return new TimeSpan(Units.Days, length);
    }

    public static TimeSpan months(int length) {
        return new TimeSpan(Units.Months, length);
    }

    public static TimeSpan years(int length) {
        return new TimeSpan(Units.Years, length);
    }

    public static TimeSpan fromString(String s) {
        if (s == null) {
            return null;
        }
        Units[] u = Units.values();
        int i = 0;
        while (i < u.length) {
            if (s.endsWith(u[i].toString())) {
                int length = Integer.parseInt(s.substring(0, s.length() - u[i].toString().length()));
                return new TimeSpan(u[i], length);
            }
            ++i;
        }
        try {
            int length = Integer.parseInt(s);
            return new TimeSpan(Units.Minutes, length);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected TimeSpan(Units units, int length) {
        this.units = units;
        this.length = length;
    }

    public Units getUnits() {
        return this.units;
    }

    public int getLength() {
        return this.length;
    }

    public int hashCode() {
        return this.length * 11 + this.units.hashCode() * 7;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimeSpan)) {
            return false;
        }
        return ((TimeSpan)obj).getUnits() == this.getUnits() && ((TimeSpan)obj).getLength() == this.getLength();
    }

    public String toString() {
        return NLS.bind((String)"{0}{1}", (Object[])new Object[]{String.valueOf(this.length), this.units.toString()});
    }

    public static enum Units {
        Minutes("m"),
        Days("d"),
        Months("mn"),
        Years("yr");

        private String name;

        private Units(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

