/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.feed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.feed.IBook;
import org.eclipsetrader.core.feed.IFeedConnector;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.feed.IFeedSubscription;
import org.eclipsetrader.core.feed.ILastClose;
import org.eclipsetrader.core.feed.IPricingEnvironment;
import org.eclipsetrader.core.feed.IPricingListener;
import org.eclipsetrader.core.feed.IQuote;
import org.eclipsetrader.core.feed.ISubscriptionListener;
import org.eclipsetrader.core.feed.ITodayOHL;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.feed.PricingDelta;
import org.eclipsetrader.core.feed.PricingEvent;
import org.eclipsetrader.core.feed.QuoteDelta;
import org.eclipsetrader.core.feed.QuoteEvent;
import org.eclipsetrader.core.instruments.ISecurity;
import pk.com.softech.tradingterminal.core.CorePlugin;

public class SingleFeedPricingEnvironment
implements IPricingEnvironment {
    private IFeedConnector connector;
    Map<ISecurity, PricingStatus> securitiesMap = new HashMap<ISecurity, PricingStatus>();
    Map<IFeedIdentifier, SubscriptionStatus> identifiersMap = new HashMap<IFeedIdentifier, SubscriptionStatus>();
    private ListenerList listeners = new ListenerList(1);
    private ISubscriptionListener listener = new ISubscriptionListener(){

        @Override
        public void quoteUpdate(QuoteEvent event) {
            SingleFeedPricingEnvironment.this.processUpdateQuotes(event.getIdentifier(), event.getDelta());
        }
    };

    protected SingleFeedPricingEnvironment() {
    }

    public SingleFeedPricingEnvironment(IFeedConnector connector) {
        this.connector = connector;
    }

    public void addSecurity(ISecurity security) {
        IFeedIdentifier identifier = (IFeedIdentifier)security.getAdapter(IFeedIdentifier.class);
        PricingStatus pricingStatus = this.securitiesMap.get(security);
        if (pricingStatus == null) {
            pricingStatus = new PricingStatus();
            this.securitiesMap.put(security, pricingStatus);
        }
        if (identifier != null) {
            SubscriptionStatus subscriptionStatus = this.identifiersMap.get(identifier);
            if (subscriptionStatus == null) {
                subscriptionStatus = new SubscriptionStatus();
                this.identifiersMap.put(identifier, subscriptionStatus);
            }
            subscriptionStatus.securities.add(security);
            if (subscriptionStatus.subscription == null) {
                subscriptionStatus.subscription = this.connector.subscribe(identifier);
                subscriptionStatus.subscription.addSubscriptionListener(this.listener);
            }
            pricingStatus.trade = subscriptionStatus.subscription.getTrade();
            pricingStatus.quote = subscriptionStatus.subscription.getQuote();
            pricingStatus.todayOHL = subscriptionStatus.subscription.getTodayOHL();
            pricingStatus.lastClose = subscriptionStatus.subscription.getLastClose();
        }
    }

    public void addSecurities(ISecurity[] securities) {
        ISecurity[] iSecurityArray = securities;
        int n = securities.length;
        int n2 = 0;
        while (n2 < n) {
            ISecurity security = iSecurityArray[n2];
            this.addSecurity(security);
            ++n2;
        }
    }

    public void removeSecurity(ISecurity security) {
        SubscriptionStatus subscriptionStatus;
        IFeedIdentifier identifier = (IFeedIdentifier)security.getAdapter(IFeedIdentifier.class);
        this.securitiesMap.remove(security);
        if (identifier != null && (subscriptionStatus = this.identifiersMap.get(identifier)) != null) {
            subscriptionStatus.securities.remove(security);
            if (subscriptionStatus.securities.size() == 0) {
                subscriptionStatus.subscription.removeSubscriptionListener(this.listener);
                this.identifiersMap.remove(identifier);
                subscriptionStatus.subscription.dispose();
            }
        }
    }

    public void removeSecurities(ISecurity[] securities) {
        ISecurity[] iSecurityArray = securities;
        int n = securities.length;
        int n2 = 0;
        while (n2 < n) {
            ISecurity security = iSecurityArray[n2];
            this.removeSecurity(security);
            ++n2;
        }
    }

    @Override
    public void addPricingListener(IPricingListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removePricingListener(IPricingListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void dispose() {
        this.listeners.clear();
        for (SubscriptionStatus pricingStatus : this.identifiersMap.values()) {
            if (pricingStatus.subscription == null) continue;
            pricingStatus.subscription.removeSubscriptionListener(this.listener);
        }
        this.identifiersMap.clear();
        this.securitiesMap.clear();
    }

    @Override
    public ITrade getTrade(ISecurity security) {
        return this.securitiesMap.get(security) != null ? this.securitiesMap.get((Object)security).trade : null;
    }

    @Override
    public IQuote getQuote(ISecurity security) {
        return this.securitiesMap.get(security) != null ? this.securitiesMap.get((Object)security).quote : null;
    }

    @Override
    public ITodayOHL getTodayOHL(ISecurity security) {
        return this.securitiesMap.get(security) != null ? this.securitiesMap.get((Object)security).todayOHL : null;
    }

    @Override
    public ILastClose getLastClose(ISecurity security) {
        return this.securitiesMap.get(security) != null ? this.securitiesMap.get((Object)security).lastClose : null;
    }

    @Override
    public IBook getBook(ISecurity security) {
        return this.securitiesMap.get(security) != null ? this.securitiesMap.get((Object)security).book : null;
    }

    protected void processUpdateQuotes(IFeedIdentifier identifier, QuoteDelta[] delta) {
        SubscriptionStatus subscriptionStatus = this.identifiersMap.get(identifier);
        if (subscriptionStatus != null) {
            for (ISecurity security : subscriptionStatus.securities) {
                PricingStatus pricingStatus = this.securitiesMap.get(security);
                if (pricingStatus == null) continue;
                QuoteDelta[] quoteDeltaArray = delta;
                int n = delta.length;
                int n2 = 0;
                while (n2 < n) {
                    QuoteDelta d = quoteDeltaArray[n2];
                    if (d.getNewValue() instanceof ITrade) {
                        pricingStatus.trade = (ITrade)d.getNewValue();
                    }
                    if (d.getNewValue() instanceof IQuote) {
                        pricingStatus.quote = (IQuote)d.getNewValue();
                    }
                    if (d.getNewValue() instanceof ITodayOHL) {
                        pricingStatus.todayOHL = (ITodayOHL)d.getNewValue();
                    }
                    if (d.getNewValue() instanceof ILastClose) {
                        pricingStatus.lastClose = (ILastClose)d.getNewValue();
                    }
                    if (d.getNewValue() instanceof IBook) {
                        pricingStatus.book = (IBook)d.getNewValue();
                    }
                    pricingStatus.deltas.add(new PricingDelta(security, d.getOldValue(), d.getNewValue()));
                    ++n2;
                }
            }
            this.notifyListeners();
        }
    }

    protected void notifyListeners() {
        Object[] l = this.listeners.getListeners();
        for (ISecurity security : this.securitiesMap.keySet()) {
            PricingStatus status = this.securitiesMap.get(security);
            if (status == null || status.deltas.size() == 0) continue;
            final PricingEvent event = new PricingEvent(security, status.deltas.toArray(new PricingDelta[status.deltas.size()]));
            int i = 0;
            while (i < l.length) {
                final IPricingListener listener = (IPricingListener)l[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        listener.pricingUpdate(event);
                    }

                    public void handleException(Throwable exception) {
                        Status status = new Status(4, "pk.com.softech.tradingterminal.core", 0, "Error running pricing environment listener", exception);
                        CorePlugin.getDefault().getLog().log((IStatus)status);
                    }
                });
                ++i;
            }
            status.deltas.clear();
        }
    }

    PricingStatus getPricingStatus(ISecurity security) {
        return this.securitiesMap.get(security);
    }

    SubscriptionStatus getSubscriptionStatus(ISecurity security) {
        IFeedIdentifier identifier = (IFeedIdentifier)security.getAdapter(IFeedIdentifier.class);
        return identifier != null ? this.identifiersMap.get(identifier) : null;
    }

    class PricingStatus {
        ITrade trade;
        IQuote quote;
        ITodayOHL todayOHL;
        ILastClose lastClose;
        IBook book;
        List<PricingDelta> deltas = new ArrayList<PricingDelta>();
        IFeedSubscription subscription;

        PricingStatus() {
        }
    }

    class SubscriptionStatus {
        IFeedSubscription subscription;
        List<ISecurity> securities = new ArrayList<ISecurity>();

        SubscriptionStatus() {
        }
    }
}

