/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.feed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipsetrader.core.feed.IBook;
import org.eclipsetrader.core.feed.ILastClose;
import org.eclipsetrader.core.feed.IPricingEnvironment;
import org.eclipsetrader.core.feed.IPricingListener;
import org.eclipsetrader.core.feed.IQuote;
import org.eclipsetrader.core.feed.ITodayOHL;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.feed.PricingDelta;
import org.eclipsetrader.core.feed.PricingEvent;
import org.eclipsetrader.core.instruments.ISecurity;
import pk.com.softech.tradingterminal.core.CorePlugin;

public class PricingEnvironment
implements IPricingEnvironment {
    private ListenerList listeners = new ListenerList(1);
    private boolean doNotify = true;
    private Map<ISecurity, PricingStatus> map = new HashMap<ISecurity, PricingStatus>();
    private final ILock lock = Job.getJobManager().newLock();

    @Override
    public void dispose() {
        this.listeners.clear();
        this.map.clear();
    }

    @Override
    public void addPricingListener(IPricingListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removePricingListener(IPricingListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public ITrade getTrade(ISecurity security) {
        return this.map.get(security) != null ? this.map.get((Object)security).trade : null;
    }

    public void setTrade(ISecurity security, ITrade trade) {
        ITrade oldValue;
        PricingStatus status = this.map.get(security);
        if (status == null) {
            status = new PricingStatus();
            this.map.put(security, status);
        }
        if ((oldValue = status.trade) == null && trade != null || oldValue != null && !oldValue.equals(trade)) {
            status.trade = trade;
            status.deltas.add(new PricingDelta(security, oldValue, trade));
            if (this.doNotify) {
                this.notifyListeners();
            }
        }
    }

    @Override
    public IQuote getQuote(ISecurity security) {
        return this.map.get(security) != null ? this.map.get((Object)security).quote : null;
    }

    public void setQuote(ISecurity security, IQuote quote) {
        IQuote oldValue;
        PricingStatus status = this.map.get(security);
        if (status == null) {
            status = new PricingStatus();
            this.map.put(security, status);
        }
        if ((oldValue = status.quote) == null && quote != null || oldValue != null && !oldValue.equals(quote)) {
            status.quote = quote;
            status.deltas.add(new PricingDelta(security, oldValue, quote));
            if (this.doNotify) {
                this.notifyListeners();
            }
        }
    }

    @Override
    public ITodayOHL getTodayOHL(ISecurity security) {
        return this.map.get(security) != null ? this.map.get((Object)security).todayOHL : null;
    }

    public void setTodayOHL(ISecurity security, ITodayOHL todayOHL) {
        ITodayOHL oldValue;
        PricingStatus status = this.map.get(security);
        if (status == null) {
            status = new PricingStatus();
            this.map.put(security, status);
        }
        if ((oldValue = status.todayOHL) == null && todayOHL != null || oldValue != null && !oldValue.equals(todayOHL)) {
            status.todayOHL = todayOHL;
            status.deltas.add(new PricingDelta(security, oldValue, todayOHL));
            if (this.doNotify) {
                this.notifyListeners();
            }
        }
    }

    @Override
    public ILastClose getLastClose(ISecurity security) {
        return this.map.get(security) != null ? this.map.get((Object)security).lastClose : null;
    }

    public void setLastClose(ISecurity security, ILastClose lastClose) {
        ILastClose oldValue;
        PricingStatus status = this.map.get(security);
        if (status == null) {
            status = new PricingStatus();
            this.map.put(security, status);
        }
        if ((oldValue = status.lastClose) == null && lastClose != null || oldValue != null && !oldValue.equals(lastClose)) {
            status.lastClose = lastClose;
            status.deltas.add(new PricingDelta(security, oldValue, lastClose));
            if (this.doNotify) {
                this.notifyListeners();
            }
        }
    }

    @Override
    public IBook getBook(ISecurity security) {
        return this.map.get(security) != null ? this.map.get((Object)security).book : null;
    }

    public void setBook(ISecurity security, IBook book) {
        IBook oldValue;
        PricingStatus status = this.map.get(security);
        if (status == null) {
            status = new PricingStatus();
            this.map.put(security, status);
        }
        if ((oldValue = status.book) == null && book != null || oldValue != null && !oldValue.equals(book)) {
            status.book = book;
            status.deltas.add(new PricingDelta(security, oldValue, book));
            if (this.doNotify) {
                this.notifyListeners();
            }
        }
    }

    public void runBatch(Runnable runnable) {
        try {
            try {
                this.lock.acquire();
                this.doNotify = false;
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    Status status = new Status(4, "pk.com.softech.tradingterminal.core", 0, "Error running pricing environment batch", (Throwable)e);
                    CorePlugin.getDefault().getLog().log((IStatus)status);
                }
                catch (LinkageError e) {
                    Status status = new Status(4, "pk.com.softech.tradingterminal.core", 0, "Error running pricing environment batch", (Throwable)e);
                    CorePlugin.getDefault().getLog().log((IStatus)status);
                }
                this.notifyListeners();
                this.doNotify = true;
            }
            catch (Exception e) {
                Status status = new Status(4, "pk.com.softech.tradingterminal.core", 0, "Error running pricing environment batch", (Throwable)e);
                CorePlugin.getDefault().getLog().log((IStatus)status);
                this.lock.release();
            }
        }
        finally {
            this.lock.release();
        }
    }

    protected void notifyListeners() {
        Object[] l = this.listeners.getListeners();
        for (ISecurity security : this.map.keySet()) {
            PricingStatus status = this.map.get(security);
            if (status == null || status.deltas.size() == 0) continue;
            final PricingEvent event = new PricingEvent(security, status.deltas.toArray(new PricingDelta[status.deltas.size()]));
            int i = 0;
            while (i < l.length) {
                final IPricingListener listener = (IPricingListener)l[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        listener.pricingUpdate(event);
                    }

                    public void handleException(Throwable exception) {
                        Status status = new Status(4, "pk.com.softech.tradingterminal.core", 0, "Error running pricing environment listener", exception);
                        CorePlugin.getDefault().getLog().log((IStatus)status);
                    }
                });
                ++i;
            }
            status.deltas.clear();
        }
    }

    PricingStatus getStatus(ISecurity security) {
        return this.map.get(security);
    }

    class PricingStatus {
        ITrade trade;
        IQuote quote;
        ITodayOHL todayOHL;
        ILastClose lastClose;
        IBook book;
        List<PricingDelta> deltas = new ArrayList<PricingDelta>();

        PricingStatus() {
        }
    }
}

