/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.feed;

import java.util.Date;
import org.eclipsetrader.core.feed.IOHLC;

public class OHLC
implements IOHLC {
    private Date date;
    private Double open;
    private Double high;
    private Double low;
    private Double close;
    private Long volume;

    public OHLC(Date date, Double open, Double high, Double low, Double close, Long volume) {
        this.date = date;
        this.open = open;
        this.high = high;
        this.low = low;
        this.close = close;
        this.volume = volume;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public Double getOpen() {
        return this.open;
    }

    @Override
    public Double getHigh() {
        return this.high;
    }

    @Override
    public Double getLow() {
        return this.low;
    }

    @Override
    public Double getClose() {
        return this.close;
    }

    @Override
    public Long getVolume() {
        return this.volume;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IOHLC)) {
            return false;
        }
        IOHLC other = (IOHLC)obj;
        return (this.getDate() == other.getDate() || this.getDate() != null && this.getDate().equals(other.getDate())) && (this.getOpen() == other.getOpen() || this.getOpen() != null && this.getOpen().equals(other.getOpen())) && (this.getHigh() == other.getHigh() || this.getHigh() != null && this.getHigh().equals(other.getHigh())) && (this.getLow() == other.getLow() || this.getLow() != null && this.getLow().equals(other.getLow())) && (this.getClose() == other.getClose() || this.getClose() != null && this.getClose().equals(other.getClose())) && (this.getVolume() == other.getVolume() || this.getVolume() != null && this.getVolume().equals(other.getVolume()));
    }

    public int hashCode() {
        return 3 * (this.date != null ? this.date.hashCode() : 0) + 7 * (this.open != null ? this.open.hashCode() : 0) + 11 * (this.high != null ? this.high.hashCode() : 0) + 13 * (this.low != null ? this.low.hashCode() : 0) + 17 * (this.close != null ? this.close.hashCode() : 0) + 19 * (this.volume != null ? this.volume.hashCode() : 0);
    }

    public void update(IOHLC bar) {
        if (bar.getHigh() > this.high) {
            this.high = bar.getHigh();
        }
        if (bar.getLow() < this.low) {
            this.low = bar.getLow();
        }
        this.close = bar.getClose();
        this.volume = this.volume + bar.getClose().longValue();
    }

    public String toString() {
        return "[" + this.date + " O=" + this.open + " H=" + this.high + " L=" + this.low + " C=" + this.close + " V=" + this.volume + "]";
    }
}

