/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.feed;

import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.ISplit;
import org.eclipsetrader.core.feed.OHLC;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;

public class HistoryDay
implements IHistory {
    private ISecurity security;
    private IOHLC[] bars = new IOHLC[0];
    private TimeSpan timeSpan;
    private IOHLC highest;
    private IOHLC lowest;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected HistoryDay() {
    }

    public HistoryDay(ISecurity security, TimeSpan timeSpan) {
        this.security = security;
        this.timeSpan = timeSpan;
    }

    public HistoryDay(ISecurity security, TimeSpan timeSpan, IOHLC[] bars) {
        this.security = security;
        this.timeSpan = timeSpan;
        this.bars = bars;
    }

    public IOHLC[] getAdjustedOHLC() {
        return this.bars;
    }

    @Override
    public IOHLC getFirst() {
        return this.bars != null && this.bars.length != 0 ? this.bars[0] : null;
    }

    @Override
    public IOHLC getHighest() {
        return this.highest;
    }

    @Override
    public IOHLC getLast() {
        return this.bars != null && this.bars.length != 0 ? this.bars[this.bars.length - 1] : null;
    }

    @Override
    public IOHLC getLowest() {
        return this.lowest;
    }

    @Override
    public IOHLC[] getOHLC() {
        return this.bars;
    }

    @Override
    public void setOHLC(IOHLC[] bars) {
        IOHLC[] oldValue = this.bars;
        ArrayList<IOHLC> l = new ArrayList<IOHLC>(Arrays.asList(bars));
        Collections.sort(l, new Comparator<IOHLC>(){

            @Override
            public int compare(IOHLC o1, IOHLC o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        this.bars = l.toArray(new IOHLC[l.size()]);
        this.updateRange();
        this.propertyChangeSupport.firePropertyChange("bars", oldValue, this.bars);
    }

    @Override
    public void addOHLC(IOHLC bar) {
        IOHLC[] oldValue = this.bars;
        ArrayList<IOHLC> l = new ArrayList<IOHLC>(Arrays.asList(this.bars));
        Collections.sort(l, new Comparator<IOHLC>(){

            @Override
            public int compare(IOHLC o1, IOHLC o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        l.add(bar);
        this.bars = l.toArray(new IOHLC[l.size()]);
        this.updateRange();
        this.propertyChangeSupport.firePropertyChange("bars", oldValue, this.bars);
    }

    @Override
    public ISecurity getSecurity() {
        return this.security;
    }

    protected void setSecurity(ISecurity security) {
        this.security = security;
    }

    @Override
    public ISplit[] getSplits() {
        return null;
    }

    public void setSplits(ISplit[] splits) {
    }

    @Override
    public IHistory getSubset(Date first, Date last) {
        ArrayList<IOHLC> l = new ArrayList<IOHLC>();
        int minutes = 1;
        OHLC currentBar = null;
        Calendar nextBarTime = Calendar.getInstance();
        Calendar barTime = Calendar.getInstance();
        if (this.timeSpan != null) {
            minutes = this.timeSpan.getLength();
        }
        IOHLC[] iOHLCArray = this.bars;
        int n = this.bars.length;
        int n2 = 0;
        while (n2 < n) {
            IOHLC bar = iOHLCArray[n2];
            if (currentBar != null && currentBar.getDate() != null) {
                barTime.setTime(bar.getDate());
                if (barTime.after(nextBarTime) || barTime.equals(nextBarTime)) {
                    l.add(currentBar);
                    currentBar = null;
                }
            }
            if (currentBar == null) {
                currentBar = new OHLC(bar.getDate(), bar.getOpen(), bar.getHigh(), bar.getLow(), bar.getClose(), bar.getVolume());
                barTime.setTime(bar.getDate());
                barTime.set(14, 0);
                barTime.add(12, -(barTime.get(12) % minutes));
                nextBarTime.setTime(currentBar.getDate());
                nextBarTime.add(12, minutes);
            }
            currentBar.update(bar);
            ++n2;
        }
        if (currentBar != null) {
            l.add(this.getLast());
        }
        return new HistoryDay(this.security, this.timeSpan, l.toArray(new IOHLC[l.size()]));
    }

    @Override
    public IHistory getSubset(Date first, Date last, TimeSpan aggregation) {
        if (this.timeSpan != null && this.timeSpan.equals(aggregation)) {
            return this.getSubset(first, last);
        }
        return null;
    }

    @Override
    public TimeSpan getTimeSpan() {
        return this.timeSpan;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (adapter.isAssignableFrom(PropertyChangeSupport.class)) {
            return this.propertyChangeSupport;
        }
        return null;
    }

    protected void updateRange() {
        this.highest = null;
        this.lowest = null;
        IOHLC[] iOHLCArray = this.bars;
        int n = this.bars.length;
        int n2 = 0;
        while (n2 < n) {
            IOHLC b = iOHLCArray[n2];
            if (this.highest == null || b.getHigh() > this.highest.getHigh()) {
                this.highest = b;
            }
            if (this.lowest == null || b.getLow() < this.lowest.getLow()) {
                this.lowest = b;
            }
            ++n2;
        }
    }
}

