/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.feed;

import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import org.eclipsetrader.core.feed.IDividend;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.ISplit;
import org.eclipsetrader.core.feed.OHLC;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;

public class History
implements IHistory {
    private ISecurity security;
    private IOHLC[] bars = new IOHLC[0];
    private ISplit[] splits = new ISplit[0];
    private TimeSpan timeSpan;
    private IOHLC highest;
    private IOHLC lowest;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected History() {
    }

    public History(ISecurity security, IOHLC[] bars) {
        this(security, bars, null, TimeSpan.days(1));
    }

    public History(ISecurity security, IOHLC[] bars, TimeSpan timeSpan) {
        this.timeSpan = timeSpan;
        this.setSecurity(security);
        this.setOHLC(bars);
    }

    public History(ISecurity security, IOHLC[] bars, ISplit[] splits, TimeSpan timeSpan) {
        this.timeSpan = timeSpan;
        this.setSecurity(security);
        this.setOHLC(bars);
        this.setSplits(splits);
    }

    @Override
    public ISecurity getSecurity() {
        return this.security;
    }

    protected void setSecurity(ISecurity security) {
        this.security = security;
    }

    @Override
    public IOHLC getFirst() {
        return this.bars != null && this.bars.length != 0 ? this.bars[0] : null;
    }

    @Override
    public IOHLC getLast() {
        return this.bars != null && this.bars.length != 0 ? this.bars[this.bars.length - 1] : null;
    }

    @Override
    public IOHLC getHighest() {
        return this.highest;
    }

    @Override
    public IOHLC getLowest() {
        return this.lowest;
    }

    @Override
    public IOHLC[] getOHLC() {
        return this.bars;
    }

    @Override
    public void setOHLC(IOHLC[] bars) {
        IOHLC[] oldValue = this.bars;
        ArrayList<IOHLC> l = new ArrayList<IOHLC>(Arrays.asList(bars));
        Collections.sort(l, new Comparator<IOHLC>(){

            @Override
            public int compare(IOHLC o1, IOHLC o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        this.bars = l.toArray(new IOHLC[l.size()]);
        this.updateRange();
        this.propertyChangeSupport.firePropertyChange("bars", oldValue, this.bars);
    }

    @Override
    public void addOHLC(IOHLC bar) {
        IOHLC[] oldValue = this.bars;
        ArrayList<IOHLC> l = new ArrayList<IOHLC>(Arrays.asList(this.bars));
        Collections.sort(l, new Comparator<IOHLC>(){

            @Override
            public int compare(IOHLC o1, IOHLC o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        l.add(bar);
        this.bars = l.toArray(new IOHLC[l.size()]);
        this.updateRange();
        this.propertyChangeSupport.firePropertyChange("bars", oldValue, this.bars);
    }

    @Override
    public IHistory getSubset(Date first, Date last) {
        ArrayList<IOHLC> l = new ArrayList<IOHLC>();
        IOHLC[] iOHLCArray = this.bars;
        int n = this.bars.length;
        int n2 = 0;
        while (n2 < n) {
            IOHLC b = iOHLCArray[n2];
            if (!(first != null && b.getDate().before(first) || last != null && b.getDate().after(last))) {
                l.add(b);
            }
            ++n2;
        }
        return new History(this.security, l.toArray(new IOHLC[l.size()]), this.timeSpan);
    }

    @Override
    public IHistory getSubset(Date first, Date last, TimeSpan timeSpan) {
        return this.getSubset(first, last);
    }

    @Override
    public TimeSpan getTimeSpan() {
        return this.timeSpan;
    }

    @Override
    public ISplit[] getSplits() {
        return this.splits;
    }

    public void setSplits(ISplit[] splits) {
        ISplit[] oldValue = this.splits;
        this.splits = splits;
        this.propertyChangeSupport.firePropertyChange("splits", oldValue, this.splits);
    }

    public IOHLC[] getAdjustedOHLC() {
        IDividend[] dividends = (IDividend[])this.security.getAdapter(IDividend[].class);
        if (!(dividends != null && dividends.length != 0 || this.splits != null && this.splits.length != 0)) {
            return this.bars;
        }
        IOHLC[] l = new IOHLC[this.bars.length];
        int i = 0;
        while (i < l.length) {
            double splitFactor = 1.0;
            if (this.splits != null) {
                int s = 0;
                while (s < this.splits.length) {
                    if (this.bars[i].getDate().before(this.splits[s].getDate())) {
                        splitFactor *= this.splits[s].getNewQuantity() / this.splits[s].getOldQuantity();
                    }
                    ++s;
                }
            }
            double cumulatedDividends = 0.0;
            if (dividends != null) {
                int d = 0;
                while (d < dividends.length) {
                    if (this.bars[i].getDate().before(dividends[d].getExDate())) {
                        cumulatedDividends += dividends[d].getValue().doubleValue();
                    }
                    ++d;
                }
            }
            l[i] = new OHLC(this.bars[i].getDate(), this.bars[i].getOpen() / splitFactor - cumulatedDividends, this.bars[i].getHigh() / splitFactor - cumulatedDividends, this.bars[i].getLow() / splitFactor - cumulatedDividends, this.bars[i].getClose() / splitFactor - cumulatedDividends, (long)((double)this.bars[i].getVolume().longValue() * splitFactor));
            ++i;
        }
        return l;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (adapter.isAssignableFrom(PropertyChangeSupport.class)) {
            return this.propertyChangeSupport;
        }
        return null;
    }

    protected void updateRange() {
        this.highest = null;
        this.lowest = null;
        IOHLC[] iOHLCArray = this.bars;
        int n = this.bars.length;
        int n2 = 0;
        while (n2 < n) {
            IOHLC b = iOHLCArray[n2];
            if (this.highest == null || b.getHigh() > this.highest.getHigh()) {
                this.highest = b;
            }
            if (this.lowest == null || b.getLow() < this.lowest.getLow()) {
                this.lowest = b;
            }
            ++n2;
        }
    }
}

