/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.feed;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.eclipsetrader.core.feed.IFeedProperties;

public class FeedProperties
implements IFeedProperties {
    private Map<String, String> properties = new HashMap<String, String>();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public String getProperty(String id) {
        return this.properties.get(id);
    }

    @Override
    public String[] getPropertyIDs() {
        return this.properties.keySet().toArray(new String[this.properties.keySet().size()]);
    }

    @Override
    public void setProperty(String id, String value) {
        String oldValue = this.properties.get(id);
        if (value == null) {
            this.properties.remove(id);
        } else {
            this.properties.put(id, value);
        }
        this.propertyChangeSupport.firePropertyChange(id, oldValue, this.properties.get(id));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (String k : this.properties.keySet()) {
            if (s.length() != 0) {
                s.append(",");
            }
            s.append(k);
            s.append("=");
            s.append(this.properties.get(k));
        }
        return s.toString();
    }
}

