/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.feed;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipsetrader.core.feed.FeedProperties;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.feed.IFeedProperties;

public class FeedIdentifier
extends PlatformObject
implements IFeedIdentifier,
PropertyChangeListener {
    private String symbol;
    private FeedProperties properties;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public FeedIdentifier(String symbol, FeedProperties properties) {
        this.symbol = symbol;
        this.properties = properties;
        if (this.properties != null) {
            this.properties.addPropertyChangeListener(this);
        }
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        String oldValue = this.symbol;
        this.symbol = symbol;
        this.propertyChangeSupport.firePropertyChange("symbol", oldValue, this.symbol);
    }

    public IFeedProperties getProperties() {
        return this.properties;
    }

    public void setProperties(FeedProperties newProperties) {
        if (this.properties != null) {
            this.properties.removePropertyChangeListener(this);
        }
        FeedProperties oldValue = this.properties;
        this.properties = newProperties;
        if (this.properties != null) {
            this.properties.addPropertyChangeListener(this);
        }
        this.propertyChangeSupport.firePropertyChange("properties", oldValue, this.properties);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (adapter.isAssignableFrom(IFeedProperties.class)) {
            return this.properties;
        }
        if (this.properties != null && adapter.isAssignableFrom(this.properties.getClass())) {
            return this.properties;
        }
        if (adapter.isAssignableFrom(PropertyChangeSupport.class)) {
            return this.propertyChangeSupport;
        }
        return super.getAdapter(adapter);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IFeedIdentifier)) {
            return false;
        }
        IFeedIdentifier other = (IFeedIdentifier)obj;
        return this.getSymbol() == other.getSymbol() || this.getSymbol() != null && this.getSymbol().equals(other.getSymbol());
    }

    public int hashCode() {
        return 3 * (this.symbol != null ? this.symbol.hashCode() : 0);
    }

    public String toString() {
        String p = this.properties != null ? this.properties.toString() : "";
        return String.valueOf(this.symbol) + (p.length() != 0 ? "(" + p + ")" : "");
    }
}

