/*
 * Decompiled with CFR 0.152.
 */
package com.hexapixel.articles.paperclips.test;

import com.hexapixel.articles.paperclips.data.IDataObject;
import com.hexapixel.articles.paperclips.data.IGenericTable;
import com.hexapixel.articles.paperclips.test.TableItemData;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableWrapper
implements IGenericTable {
    private Table _table;
    private List<IDataObject> _allData;

    public TableWrapper(Table table) {
        this._table = table;
        this._allData = new ArrayList<IDataObject>();
    }

    @Override
    public List<IDataObject> getAllItems() {
        if (this._allData.isEmpty()) {
            TableItem[] tableItemArray = this._table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem ti = tableItemArray[n2];
                this._allData.add(new TableItemData(ti));
                ++n2;
            }
        }
        return this._allData;
    }

    @Override
    public int getBodyColumnWidth(int colIndex) {
        return this._table.getColumn(colIndex).getWidth();
    }

    @Override
    public Point[] getCellSelection() {
        ArrayList<Point> ret = new ArrayList<Point>();
        int[] sel = this._table.getSelectionIndices();
        int i = 0;
        while (i < sel.length) {
            int row = sel[i];
            int col = 0;
            while (col < this.getVisibleColumnOrder().size()) {
                Point p = new Point(0, row);
                p.x = col++;
                ret.add(p);
            }
            ++i;
        }
        Point[] toReturn = new Point[ret.size()];
        int i2 = 0;
        while (i2 < ret.size()) {
            toReturn[i2] = (Point)ret.get(i2);
            ++i2;
        }
        return toReturn;
    }

    @Override
    public int getCellSelectionCount() {
        return this._table.getSelectionCount();
    }

    @Override
    public int getColumnCount() {
        return this._table.getColumnCount();
    }

    @Override
    public List<Integer> getColumnOrder() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int[] nArray = this._table.getColumnOrder();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer col = nArray[n2];
            ret.add(col);
            ++n2;
        }
        return ret;
    }

    @Override
    public String getColumnTitle(int colIndex) {
        return this._table.getColumn(colIndex).getText();
    }

    @Override
    public IDataObject getItem(int row) {
        return this._allData.get(row);
    }

    @Override
    public List<Integer> getVisibleColumnOrder() {
        return this.getColumnOrder();
    }
}

