/*
 * Decompiled with CFR 0.152.
 */
package com.hexapixel.articles.paperclips.test;

import com.hexapixel.articles.paperclips.core.PrintFooter;
import com.hexapixel.articles.paperclips.core.PrintHeader;
import com.hexapixel.articles.paperclips.core.PrintPreviewDialog;
import com.hexapixel.articles.paperclips.test.PrintHandler;
import net.sf.paperclips.BigPrint;
import net.sf.paperclips.DefaultGridLook;
import net.sf.paperclips.GridLook;
import net.sf.paperclips.GridPrint;
import net.sf.paperclips.ImagePrint;
import net.sf.paperclips.LinePrint;
import net.sf.paperclips.PageDecoration;
import net.sf.paperclips.PagePrint;
import net.sf.paperclips.Print;
import net.sf.paperclips.TextPrint;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class GridPrintExample {
    public static void main(String[] args) {
        Display display = new Display();
        final Shell shell = new Shell(display, 1264);
        shell.setLayout((Layout)new GridLayout(1, false));
        shell.setSize(600, 600);
        Table table = new Table((Composite)shell, 67586);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        table.setLayoutData((Object)data);
        String[] titles = new String[]{" ", "C", "!", "Description", "Resource", "In Folder", "Location"};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(titles[i]);
            ++i;
        }
        int count = 25;
        int i2 = 0;
        while (i2 < count) {
            TableItem item = new TableItem(table, 0);
            item.setText(0, "x");
            item.setText(1, "y");
            item.setText(2, "!");
            item.setText(3, "this stuff behaves the way I expect");
            item.setText(4, "almost everywhere");
            item.setText(5, "some.folder");
            item.setText(6, "line " + i2 + " in nowhere");
            ++i2;
        }
        i2 = 0;
        while (i2 < titles.length) {
            table.getColumn(i2).pack();
            ++i2;
        }
        Button btn = new Button((Composite)shell, 8);
        btn.setText("print");
        btn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    BigPrint big = new BigPrint(GridPrintExample.createPrint());
                    PrintHandler printhandler = new PrintHandler();
                    PagePrint pp = new PagePrint((PageDecoration)new PrintHeader(printhandler, "Margin View"), (Print)big, (PageDecoration)new PrintFooter("My Footer"));
                    pp.setHeaderGap(5);
                    pp.setFooterGap(5);
                    PrintPreviewDialog ppd = new PrintPreviewDialog((Print)pp, shell, printhandler);
                    ppd.open();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public static Print createPrint() {
        GridPrint grid = new GridPrint("r:72, p, d, r:d:g(3), r:d:g", (GridLook)new DefaultGridLook(5, 5));
        ImageData imageData = new ImageData(GridPrintExample.class.getResourceAsStream("aa2.png"));
        int dpiX = Display.getDefault().getDPI().x;
        System.out.println("DPI x " + dpiX);
        int width = imageData.width;
        System.out.println("Width " + width);
        System.out.println(72.0 / (double)dpiX * (double)width);
        ImagePrint image = new ImagePrint(imageData);
        image.setDPI(130, 130);
        grid.add(0x1000000, (Print)image, -1);
        FontData fontData = new FontData("Arial", 10, 1);
        grid.add((Print)new LinePrint(), -1);
        grid.add(0x1000000, (Print)new TextPrint("LOTS AND LOTS AND LOTS AND LOTS AND LOTS OF TEXT", fontData, 0x1000000), -1);
        GridPrint child = new GridPrint("d:g, d:g", (GridLook)new DefaultGridLook(10, 10));
        child.add((Print)new TextPrint("This is a line with some text.", fontData));
        child.add((Print)new TextPrint("This is a line with lots of text.  Where is all this text coming from??", fontData));
        grid.add(16384, (Print)child, -1);
        return grid;
    }
}

