/*
 * Decompiled with CFR 0.152.
 */
package com.hexapixel.articles.paperclips.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageCache {
    private static HashMap<String, Image> _imageMap = new HashMap();
    private static final String ICON_ROOT_PATH = "/icons/";

    public static Image getImage(String fileName) {
        Image image = _imageMap.get(fileName = ICON_ROOT_PATH + fileName);
        if (image == null) {
            image = ImageCache.createImage(fileName);
            _imageMap.put(fileName, image);
        }
        return image;
    }

    private static Image createImage(String fileName) {
        ClassLoader classLoader = ImageCache.class.getClassLoader();
        InputStream is = classLoader.getResourceAsStream(fileName);
        if (is == null && (is = classLoader.getResourceAsStream(fileName.substring(1))) == null && (is = classLoader.getResourceAsStream(fileName)) == null && (is = classLoader.getResourceAsStream(fileName.substring(1))) == null) {
            return null;
        }
        Image img = new Image((Device)Display.getDefault(), is);
        try {
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return img;
    }

    public static void dispose() {
        Iterator<Image> e = _imageMap.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
    }
}

