/*
 * Decompiled with CFR 0.152.
 */
package com.hexapixel.articles.paperclips.core;

import com.hexapixel.articles.paperclips.core.CustomLineBorder;
import com.hexapixel.articles.paperclips.core.IPrintHandler;
import com.hexapixel.articles.paperclips.core.PrintFooter;
import com.hexapixel.articles.paperclips.core.PrintHeader;
import com.hexapixel.articles.paperclips.core.PrintPreviewDialog;
import com.hexapixel.articles.paperclips.core.PrintResultCode;
import com.hexapixel.articles.paperclips.data.IDataObject;
import com.hexapixel.articles.paperclips.data.IGenericTable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.paperclips.BigPrint;
import net.sf.paperclips.Border;
import net.sf.paperclips.CellBackgroundProvider;
import net.sf.paperclips.DefaultGridLook;
import net.sf.paperclips.GridLook;
import net.sf.paperclips.GridPrint;
import net.sf.paperclips.ImagePrint;
import net.sf.paperclips.LineBorder;
import net.sf.paperclips.PageDecoration;
import net.sf.paperclips.PagePrint;
import net.sf.paperclips.PaperClips;
import net.sf.paperclips.Print;
import net.sf.paperclips.PrintJob;
import net.sf.paperclips.TextPrint;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class GridPrinter {
    private static final String EXPANDABLE_COLUMN = "d:g";
    private static final String DOT = "...";
    private static final String EMPTY = "";
    private Image _disposeImage;
    private boolean _disposePrintImage = false;
    private RGB _evenRows;
    private RGB _oddRows;
    private RGB _headerBgColor;
    private boolean _printColHeaders;
    private boolean _printVerticalLines;
    private boolean _printHorizontalLines;
    private String _footerText;
    private FontData _headerFontData;
    private FontData _cellFontData;
    private IPrintHandler _printHandler;

    public GridPrinter(IPrintHandler handler) {
        this._printHandler = handler;
        this._printColHeaders = handler.isPrintColumnHeaders();
        this._printVerticalLines = handler.isPrintVerticalLines();
        this._printHorizontalLines = handler.isPrintHorizontalLines();
        this._footerText = handler.getFooterText();
        this._headerFontData = handler.getHeaderFontData();
        this._cellFontData = handler.getCellFontData();
        this._headerBgColor = new RGB(240, 240, 240);
        this._oddRows = new RGB(230, 230, 230);
        this._evenRows = new RGB(255, 255, 255);
    }

    public PrintResultCode printImage(boolean showPreview, String docTitle, Shell parentShell, ImageData srcImageData) {
        try {
            GridPrint parent = new GridPrint("r:72, p, d, r:d:g(3), r:d:g", (GridLook)new DefaultGridLook(5, 5));
            ImagePrint summary = new ImagePrint(srcImageData, Display.getDefault().getDPI());
            parent.add(0x1000000, (Print)summary, -1);
            GC concatGc = new GC((Drawable)parentShell);
            Font headerFont = new Font((Device)Display.getDefault(), this._headerFontData);
            Font cellFont = new Font((Device)Display.getDefault(), this._cellFontData);
            concatGc.dispose();
            headerFont.dispose();
            cellFont.dispose();
            BigPrint big = new BigPrint((Print)parent);
            PagePrint pp = new PagePrint((PageDecoration)new PrintHeader(this._printHandler, docTitle), (Print)big, (PageDecoration)new PrintFooter(this.getFooterText()));
            pp.setHeaderGap(9);
            pp.setFooterGap(18);
            if (showPreview) {
                PrintPreviewDialog ppd = new PrintPreviewDialog((Print)pp, parentShell, this._printHandler);
                ppd.open();
            } else {
                PrintDialog dialog = new PrintDialog(parentShell, 0);
                PrinterData printerData = dialog.open();
                if (printerData != null) {
                    PaperClips.print((PrintJob)new PrintJob("Printing", (Print)pp).setMargins(36), (PrinterData)printerData);
                }
            }
            if (this._disposePrintImage) {
                this._disposeImage.dispose();
            }
            return PrintResultCode.SUCCESS;
        }
        catch (Exception err) {
            err.printStackTrace();
            return PrintResultCode.ERROR_PRINTING;
        }
    }

    public PrintResultCode printTable(IGenericTable tableImpl, boolean printSelectionOnly, boolean showPreview, String docTitle, Shell parentShell, ImageData srcImageData) {
        try {
            int columnCount = tableImpl.getColumnCount();
            boolean useFullColumnWidths = false;
            StringBuffer buf = new StringBuffer();
            List<Integer> cols = null;
            ArrayList<Integer> widths = new ArrayList<Integer>();
            HashMap<Integer, Integer> widthMap = new HashMap<Integer, Integer>();
            if (printSelectionOnly) {
                if (tableImpl.getCellSelectionCount() == 0) {
                    return PrintResultCode.ERROR_NO_DATA_TO_PRINT;
                }
                Point[] points = tableImpl.getCellSelection();
                cols = new ArrayList<Integer>();
                Point[] pointArray = points;
                int n = points.length;
                int n2 = 0;
                while (n2 < n) {
                    Point p = pointArray[n2];
                    if (!cols.contains(p.x)) {
                        cols.add(p.x);
                    }
                    ++n2;
                }
                columnCount = cols.size();
            } else {
                cols = tableImpl.getVisibleColumnOrder();
                columnCount = cols.size();
            }
            List<Integer> visibleOrder = tableImpl.getColumnOrder();
            ArrayList<Integer> correctOrderedCols = new ArrayList<Integer>();
            for (Integer correct : visibleOrder) {
                if (!cols.contains(correct)) continue;
                correctOrderedCols.add(correct);
            }
            cols = correctOrderedCols;
            int i = 0;
            while (i < cols.size()) {
                int column = cols.get(i);
                widths.add(tableImpl.getBodyColumnWidth(column));
                widthMap.put(column, tableImpl.getBodyColumnWidth(column));
                if (useFullColumnWidths) {
                    buf.append(EXPANDABLE_COLUMN);
                } else {
                    int colWidthPix = tableImpl.getBodyColumnWidth(column);
                    float pts = this.convertToPoints(colWidthPix);
                    buf.append("L:");
                    buf.append((int)pts);
                    buf.append(":N");
                }
                if (i != columnCount - 1) {
                    buf.append(", ");
                }
                ++i;
            }
            GridPrint grid = null;
            GridPrint parent = new GridPrint("r:72, p, d, r:d:g(3), r:d:g", (GridLook)new DefaultGridLook(5, 5));
            ImageData imageData = srcImageData;
            ImagePrint summary = new ImagePrint(imageData, Display.getDefault().getDPI());
            parent.add(0x1000000, (Print)summary, -1);
            GC concatGc = new GC((Drawable)parentShell);
            Font headerFont = new Font((Device)Display.getDefault(), this._headerFontData);
            Font cellFont = new Font((Device)Display.getDefault(), this._cellFontData);
            DefaultGridLook look = new DefaultGridLook(0, 0);
            if (this._printHorizontalLines && this._printVerticalLines) {
                look.setCellBorder((Border)new LineBorder());
            } else if (this._printHorizontalLines) {
                look.setCellBorder((Border)new CustomLineBorder(true));
            } else if (this._printVerticalLines) {
                look.setCellBorder((Border)new CustomLineBorder(false));
            }
            grid = new GridPrint(buf.toString(), (GridLook)look);
            look.setHeaderBackgroundProvider(new CellBackgroundProvider(){

                public RGB getCellBackground(int row, int column, int colspan) {
                    return GridPrinter.this._headerBgColor;
                }
            });
            look.setBodyBackgroundProvider(new CellBackgroundProvider(){

                public RGB getCellBackground(int row, int col, int colspan) {
                    return row % 2 == 0 ? GridPrinter.this._evenRows : GridPrinter.this._oddRows;
                }
            });
            if (printSelectionOnly) {
                Point[] points = tableImpl.getCellSelection();
                if (this._printColHeaders) {
                    int i2 = 0;
                    while (i2 < cols.size()) {
                        String name = this.concat(tableImpl.getColumnTitle(cols.get(i2)), (Integer)widths.get(i2), concatGc, headerFont);
                        grid.addHeader((Print)new TextPrint(name, this._headerFontData));
                        ++i2;
                    }
                }
                HashMap selMap = new HashMap();
                int i3 = 0;
                while (i3 < points.length) {
                    ArrayList<Integer> toUse;
                    Point p = points[i3];
                    boolean newEntry = !selMap.containsKey(p.y);
                    List<Integer> list = toUse = newEntry ? new ArrayList<Integer>() : (List)selMap.get(p.y);
                    if (!toUse.contains(p.x)) {
                        toUse.add(p.x);
                    }
                    selMap.put(p.y, toUse);
                    ++i3;
                }
                ArrayList<Integer> printedRows = new ArrayList<Integer>();
                int i4 = 0;
                while (i4 < points.length) {
                    Point p = points[i4];
                    if (!printedRows.contains(p.y)) {
                        for (int col : cols) {
                            List selColsForRow = (List)selMap.get(p.y);
                            if (!selColsForRow.contains(col)) {
                                grid.add((Print)this.tp(" "));
                                continue;
                            }
                            IDataObject gi = tableImpl.getItem(p.y);
                            String value = this.concat(gi.getColumnText(col), (Integer)widthMap.get(col), concatGc, cellFont);
                            Image image = gi.getColumnImage(col);
                            if (image != null) {
                                grid.add((Print)new ImagePrint(image.getImageData(), Display.getDefault().getDPI()));
                                continue;
                            }
                            grid.add((Print)this.tp(value, this._cellFontData));
                        }
                        printedRows.add(p.y);
                    }
                    ++i4;
                }
            } else {
                List<IDataObject> all = tableImpl.getAllItems();
                IDataObject[] sel = new IDataObject[all.size()];
                sel = new IDataObject[all.size()];
                int i5 = 0;
                while (i5 < all.size()) {
                    sel[i5] = all.get(i5);
                    ++i5;
                }
                if (this._printColHeaders) {
                    i5 = 0;
                    while (i5 < cols.size()) {
                        String name = this.concat(tableImpl.getColumnTitle(cols.get(i5)), (Integer)widths.get(i5), concatGc, headerFont);
                        grid.addHeader((Print)new TextPrint(name, this._headerFontData));
                        ++i5;
                    }
                }
                IDataObject[] iDataObjectArray = sel;
                int n = sel.length;
                int name = 0;
                while (name < n) {
                    IDataObject gi = iDataObjectArray[name];
                    int i6 = 0;
                    while (i6 < cols.size()) {
                        String colText = gi.getColumnText(cols.get(i6));
                        if (colText == null) {
                            colText = EMPTY;
                        }
                        String text = this.concat(colText, (Integer)widths.get(i6), concatGc, cellFont);
                        grid.add((Print)this.tp(text, this._cellFontData));
                        ++i6;
                    }
                    ++name;
                }
            }
            concatGc.dispose();
            headerFont.dispose();
            cellFont.dispose();
            BigPrint big = new BigPrint((Print)parent);
            PagePrint pp = new PagePrint((PageDecoration)new PrintHeader(this._printHandler, docTitle), (Print)big, (PageDecoration)new PrintFooter(this.getFooterText()));
            pp.setHeaderGap(9);
            pp.setFooterGap(18);
            if (showPreview) {
                PrintPreviewDialog ppd = new PrintPreviewDialog((Print)pp, parentShell, this._printHandler);
                ppd.open();
            } else {
                PrintDialog dialog = new PrintDialog(parentShell, 0);
                PrinterData printerData = dialog.open();
                if (printerData != null) {
                    PaperClips.print((PrintJob)new PrintJob("Printing", (Print)pp).setMargins(36), (PrinterData)printerData);
                }
            }
            if (this._disposePrintImage) {
                this._disposeImage.dispose();
            }
            return PrintResultCode.SUCCESS;
        }
        catch (Exception err) {
            err.printStackTrace();
            return PrintResultCode.ERROR_PRINTING;
        }
    }

    private String concat(String str, int pixWidth, GC gc, Font f) {
        if (str == null || str.length() == 0) {
            return str;
        }
        gc.setFont(f);
        Point size = gc.stringExtent(str);
        if (size.x <= pixWidth) {
            return str;
        }
        String ret = this.getAvailableTextToDisplay(gc, new Rectangle(0, 0, pixWidth, 20), str);
        return ret;
    }

    private String getAvailableTextToDisplay(GC gc, Rectangle rectangle, String text) {
        int width = gc.textExtent((String)text).x;
        boolean displayDot = width > rectangle.width;
        String ret = null;
        try {
            if (displayDot) {
                BufferedReader bufferedReader = new BufferedReader(new StringReader(text));
                StringBuffer output = new StringBuffer();
                String line = EMPTY;
                while ((line = bufferedReader.readLine()) != null) {
                    width = gc.textExtent((String)line).x;
                    if (width > rectangle.width) {
                        int textLen = line.length();
                        int i = textLen - 1;
                        while (i >= 0) {
                            String temp = String.valueOf(line.substring(0, i)) + DOT;
                            width = gc.textExtent((String)temp).x;
                            if (width < rectangle.width) {
                                line = temp;
                                break;
                            }
                            if (i == 0) {
                                line = EMPTY;
                            }
                            --i;
                        }
                    }
                    output.append(line);
                    output.append('\n');
                }
                ret = output.toString();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private int convertToPoints(int pixels) {
        return 72 * pixels / Display.getDefault().getDPI().x;
    }

    private TextPrint tp(String str) {
        return new TextPrint(str == null ? EMPTY : (str.equals(EMPTY) ? "-" : str));
    }

    private TextPrint tp(String str, FontData fd) {
        return new TextPrint(str == null ? EMPTY : (str.equals(EMPTY) ? "-" : str), fd);
    }

    public String getFooterText() {
        return this._footerText;
    }
}

