/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class Sweet {
    private Image imageGradient;
    private Label label;
    private Composite composite;

    private void createComponents(Shell parent) {
        this.composite = new Composite((Composite)parent, 0);
        this.composite.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Sweet.this.changeImage();
            }
        });
        this.composite.setLayout((Layout)new FormLayout());
        this.composite.setBackgroundMode(1);
        this.label = new Label(this.composite, 0);
        this.label.setText("Hello, World!");
    }

    private void changeImage() {
        Image oldImage = this.imageGradient;
        Display display = this.composite.getDisplay();
        Rectangle rect = this.composite.getClientArea();
        this.imageGradient = new Image((Device)display, rect.width, rect.height);
        GC gc = new GC((Drawable)this.imageGradient);
        try {
            Color color1 = new Color((Device)display, 200, 200, 255);
            try {
                Color color2 = new Color((Device)display, 255, 255, 255);
                try {
                    gc.setForeground(color1);
                    gc.setBackground(color2);
                    gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, true);
                }
                finally {
                    color2.dispose();
                }
            }
            finally {
                color1.dispose();
            }
        }
        finally {
            gc.dispose();
        }
        this.composite.setBackgroundImage(this.imageGradient);
        if (oldImage != null) {
            oldImage.dispose();
        }
    }

    private void openShell(Display display) {
        Shell shell = new Shell(display);
        try {
            shell.setSize(200, 100);
            shell.setLayout((Layout)new FillLayout());
            this.createComponents(shell);
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            if (!shell.isDisposed()) {
                shell.dispose();
            }
        }
    }

    public void run() {
        Display display = Display.getDefault();
        try {
            this.openShell(display);
        }
        finally {
            display.dispose();
        }
    }

    public void dispose() {
        if (this.imageGradient != null) {
            this.imageGradient.dispose();
        }
    }

    public static void main(String[] args) {
        Sweet sweet = new Sweet();
        try {
            sweet.run();
        }
        finally {
            sweet.dispose();
        }
    }
}

