/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Date;

public class Drives {
    public static ArrayList<File> files = new ArrayList();
    static String filter = "MANIFEST.MF feature.xml";
    static String pathFilter = "org.eclipsetrader.core.charts,org.eclipsetrader.ui.charts,org.eclipsetrader.ui.charts-feature,org.eclipsetrader.ui.charts.indicators,pk.com.softech.tradingterminal,pk.com.softech.tradingterminal-feature,pk.com.softech.tradingterminal.admin,pk.com.softech.tradingterminal.admin.feature,pk.com.softech.tradingterminal.core,pk.com.softech.tradingterminal.ext,pk.com.softech.tradingterminal.ext-feature,pk.com.softech.tradingterminal.kseServer,pk.com.softech.tradingterminal.news,pk.com.softech.tradingterminal.news-feature,pk.com.softech.tradingterminal.notificationservice,pk.com.softech.tradingterminal.reports,pk.com.softech.tradingterminal.reports-feature,pk.com.softech.tradingterminal.trading,pk.com.softech.tradingterminal.trading-feature,pk.com.softech.tradingterminal.themes,";
    static String oldVersion = "2.1.0";
    static String newVersion = "2.1.1";
    static String rootPath = "/Users/softech/Desktop/mac-dev/workspace/BackConnect_TT/src";
    static boolean change = true;

    private static void doSimpleFileListing(String dirName) {
        System.out.println();
        System.out.println("Simple file listing...");
        System.out.println("----------------------");
        File dir = new File(dirName);
        String[] children = dir.list();
        Drives.printFiles(children, dirName);
    }

    private static void doFileFilterListing(String dirName, String ff) {
        System.out.println("Filter file listing...");
        System.out.println("----------------------");
        final String fileFilter = ff;
        File dir = new File(dirName);
        FilenameFilter filter = null;
        if (fileFilter != null) {
            filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(fileFilter);
                }
            };
        }
        String[] children = dir.list(filter);
        Drives.printFiles(children, dirName);
    }

    private static void doFileFilterDirectoryListing(String dirName) {
        System.out.println("Filter Directory listing...");
        System.out.println("---------------------------");
        File dir = new File(dirName);
        File[] files = new File(dirName).listFiles();
        FileFilter dirFilter = new FileFilter(){

            @Override
            public boolean accept(File dir) {
                return dir.isDirectory();
            }
        };
        files = dir.listFiles(dirFilter);
        int i = 0;
        while (i < files.length) {
            System.out.println("[D] : " + files[i]);
            ++i;
        }
        System.out.println();
    }

    private static void printFiles(String[] children, String dirName) {
        if (children == null) {
            System.out.println("Error with " + dirName);
            System.out.println("Either directory does not exist or is not a directory");
        } else {
            int i = 0;
            while (i < children.length) {
                String filename = children[i];
                new File(String.valueOf(dirName) + File.separatorChar + filename).isDirectory();
                System.out.println(String.valueOf(dirName) + File.separatorChar + filename);
                ++i;
            }
        }
        System.out.println();
    }

    public static void main(String[] args) {
        File.listRoots();
        Date start = new Date();
        File file = new File(rootPath);
        System.out.println("File path = " + file.getAbsolutePath());
        if (file.isDirectory()) {
            Drives.list(file.getAbsolutePath(), file.list());
        } else {
            System.out.println("Not dir");
        }
        System.out.println("start time " + start);
        System.out.println(files.size());
        System.out.println("end time " + new Date());
        int count = 0;
        int i = 0;
        while (i < files.size()) {
            count += Drives.changeVersionTag(files.get(i), change);
            ++i;
        }
        System.out.println(String.valueOf(count) + " files changed");
    }

    public static void list(String parent, String[] childs) {
        File f;
        if (childs != null && childs.length != 0) {
            int j = 0;
            while (j < childs.length) {
                String newPar = String.valueOf(parent) + File.separator + childs[j];
                Drives.list(newPar, new File(newPar).list());
                ++j;
            }
        }
        if ((f = new File(parent)).isFile()) {
            String ff = f.getAbsolutePath().substring(f.getAbsolutePath().lastIndexOf("/") + 1);
            String path = "UNKNOWN";
            if (f.getAbsolutePath().length() > 70) {
                path = f.getAbsolutePath().substring(rootPath.length(), f.getAbsolutePath().indexOf("/", rootPath.length()));
            }
            if (filter.contains(ff) && pathFilter.contains(path)) {
                files.add(f);
            }
        }
    }

    private static int changeVersionTag(File f, boolean write) {
        System.out.println("Change file " + f);
        int count = 0;
        StringBuffer buf = new StringBuffer(1024);
        try {
            if (f.isFile()) {
                BufferedReader br = new BufferedReader(new FileReader(f));
                String line = "";
                while ((line = br.readLine()) != null) {
                    if (line.contains("version=\"" + oldVersion + "\"") || line.contains("Bundle-Version: " + oldVersion)) {
                        line = line.replace(oldVersion, newVersion);
                        System.out.println("Version Changed " + line);
                        ++count;
                    }
                    buf.append(String.valueOf(line) + "\n");
                }
                if (write) {
                    FileWriter w = new FileWriter(f);
                    w.write(buf.toString());
                    w.flush();
                    w.close();
                    System.out.println("Write");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }
}

