/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Animator {
    private static final int IMAGE_WIDTH = 100;
    private static final int TIMER_INTERVAL = 10;
    private int x = 0;
    private int y = 0;
    private int directionX = 1;
    private int directionY = 1;
    private Canvas canvas;

    public void run() {
        final Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("Animator");
        this.createContents(shell);
        shell.open();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Animator.this.animate();
                display.timerExec(10, (Runnable)this);
            }
        };
        display.timerExec(10, runnable);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.timerExec(-1, runnable);
        display.dispose();
    }

    private void createContents(final Shell shell) {
        shell.setLayout((Layout)new FillLayout());
        this.canvas = new Canvas((Composite)shell, 262144);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                event.gc.fillRectangle(Animator.this.canvas.getBounds());
                event.gc.setBackground(shell.getDisplay().getSystemColor(3));
                event.gc.fillOval(Animator.this.x, Animator.this.y, 100, 100);
            }
        });
    }

    public void animate() {
        this.x += this.directionX;
        this.y += this.directionY;
        Rectangle rect = this.canvas.getClientArea();
        if (this.x < 0) {
            this.x = 0;
            this.directionX = 1;
        } else if (this.x > rect.width - 100) {
            this.x = rect.width - 100;
            this.directionX = -1;
        }
        if (this.y < 0) {
            this.y = 0;
            this.directionY = 1;
        } else if (this.y > rect.height - 100) {
            this.y = rect.height - 100;
            this.directionY = -1;
        }
        this.canvas.redraw();
    }

    public static void main(String[] args) {
        new Animator().run();
    }
}

