/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.IHistoryFeed;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Security;

public class UpdateAllHistoryChartsAction
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate {
    private Log logger = LogFactory.getLog(this.getClass());

    public void init(IWorkbenchWindow window) {
    }

    public void init(IViewPart view) {
    }

    public void dispose() {
    }

    public void run(IAction action) {
        if (Resources.tcpLink) {
            this.logger.info((Object)"update all history charts request ");
            Job job = new Job("Update chart data"){

                protected IStatus run(IProgressMonitor monitor) {
                    Object[] objs = CorePlugin.getRepository().allSecurities().toArray();
                    monitor.beginTask("Updating charts", objs.length);
                    int i = 0;
                    while (i < objs.length) {
                        IHistoryFeed feed;
                        Security security = (Security)objs[i];
                        if (security.getHistoryFeed() != null && (feed = CorePlugin.createHistoryFeedPlugin((String)security.getHistoryFeed().getId())) != null) {
                            monitor.subTask("Updating " + security.getDescription().replaceAll("&", "&&"));
                            feed.updateHistory(security, 8);
                        }
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        ++i;
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        } else {
            MessageDialog.openError(null, (String)"Connection error", (String)"You are seem to be disconnected from server");
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

