/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipsetrader.ui.charts.BaseChartViewer;
import org.eclipsetrader.ui.charts.ChartRowViewItem;
import org.eclipsetrader.ui.charts.ChartView;
import org.eclipsetrader.ui.charts.IChartEditorListener;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import org.eclipsetrader.ui.charts.IEditableChartObject;
import org.eclipsetrader.ui.internal.charts.ChartsUIActivator;

public class ToolAction
extends Action {
    private IViewPart viewPart;
    private String chartObjectId;
    private IChartObjectFactory factory;
    private IChartObject chartObject;
    private IChartEditorListener editorListener = new IChartEditorListener(){

        @Override
        public void applyEditorValue() {
            BaseChartViewer viewer = (BaseChartViewer)ToolAction.this.viewPart.getAdapter(BaseChartViewer.class);
            viewer.getEditor().removeListener(ToolAction.this.editorListener);
            ToolAction.this.handleApplyEditorValue();
        }

        @Override
        public void cancelEditor() {
            BaseChartViewer viewer = (BaseChartViewer)ToolAction.this.viewPart.getAdapter(BaseChartViewer.class);
            viewer.getEditor().removeListener(ToolAction.this.editorListener);
            ToolAction.this.handleCancelEditor();
        }
    };

    public ToolAction(String title, IViewPart viewPart, String chartObjectId) {
        super(title, 2);
        this.setId(chartObjectId);
        this.viewPart = viewPart;
        this.chartObjectId = chartObjectId;
    }

    public void run() {
        this.factory = ChartsUIActivator.getDefault().getChartObjectFactory(this.chartObjectId);
        if (this.factory != null) {
            this.chartObject = this.factory.createObject(null);
            if (this.chartObject instanceof IEditableChartObject) {
                BaseChartViewer viewer = (BaseChartViewer)this.viewPart.getAdapter(BaseChartViewer.class);
                viewer.getEditor().addListener(this.editorListener);
                viewer.activateEditor((IEditableChartObject)this.chartObject);
            }
        }
    }

    protected void handleApplyEditorValue() {
        BaseChartViewer viewer = (BaseChartViewer)this.viewPart.getAdapter(BaseChartViewer.class);
        IChartObject[] currentObject = viewer.getSelectedChartCanvas().getChartObject();
        int index = viewer.getSelectedChartCanvasIndex();
        if (index != -1) {
            IChartObject[] newObject = new IChartObject[currentObject.length + 1];
            System.arraycopy(currentObject, 0, newObject, 0, currentObject.length);
            newObject[currentObject.length] = this.chartObject;
            viewer.getSelectedChartCanvas().setChartObject(newObject);
            ChartView view = (ChartView)this.viewPart.getAdapter(ChartView.class);
            ((ChartRowViewItem)view.getItems()[index]).addFactory(this.factory);
            viewer.setSelection((ISelection)new StructuredSelection((Object)this.chartObject));
        }
        this.factory = null;
        this.chartObject = null;
        this.setChecked(false);
    }

    protected void handleCancelEditor() {
        this.factory = null;
        this.chartObject = null;
        this.setChecked(false);
    }

    protected IChartObjectFactory getFactory() {
        return this.factory;
    }
}

