/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.ui.internal.charts.views.ChartViewPart;
import org.eclipsetrader.ui.internal.charts.views.Messages;

public class PeriodAction
extends Action {
    private ChartViewPart view;
    private TimeSpan period;
    private TimeSpan resolution;

    public PeriodAction(ChartViewPart view, String text, TimeSpan period, TimeSpan resolution, ImageDescriptor image) {
        super(text, 8);
        this.view = view;
        this.period = period;
        this.resolution = resolution;
        if (image != null) {
            this.setImageDescriptor(image);
        }
    }

    public PeriodAction(ChartViewPart view, TimeSpan period, TimeSpan resolution, ImageDescriptor image) {
        super("", 8);
        this.view = view;
        this.period = period;
        this.resolution = resolution;
        if (image != null) {
            this.setImageDescriptor(image);
        }
        String unit = "";
        switch (period.getUnits()) {
            case Days: {
                unit = String.valueOf(Messages.PeriodAction_DaysText) + " (" + resolution + ")";
                break;
            }
            case Months: {
                unit = Messages.PeriodAction_MonthsText;
                break;
            }
            case Years: {
                unit = Messages.PeriodAction_Yearstext;
            }
        }
        this.setText(NLS.bind((String)"{0} {1}", (Object[])new Object[]{String.valueOf(period.getLength()), unit}));
    }

    public void run() {
        if (this.isChecked()) {
            this.view.setPeriod(this.period, this.resolution);
        }
    }

    public TimeSpan getPeriod() {
        return this.period;
    }

    public TimeSpan getResolution() {
        return this.resolution;
    }
}

