/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.nebula.widgets.pshelf.PShelf;
import org.eclipse.nebula.widgets.pshelf.PShelfItem;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipsetrader.ui.charts.ChartObjectFactoryTransfer;
import org.eclipsetrader.ui.internal.charts.ChartsUIActivator;
import org.eclipsetrader.ui.internal.charts.views.Messages;
import org.eclipsetrader.ui.internal.charts.views.SelectionProvider;

public class PaletteView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipsetrader.ui.charts.palette";
    public static final String K_ID = "id";
    public static final String K_NAME = "name";
    public static final String K_DESCRIPTION = "description";
    public static final String K_ICON = "icon";
    public static final String K_CATEGORY = "category";
    private PShelf shelf;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        site.setSelectionProvider((ISelectionProvider)new SelectionProvider());
    }

    public void createPartControl(Composite parent) {
        this.shelf = new PShelf(parent, 0);
        this.createItems();
        this.shelf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewer viewer = (TableViewer)e.item.getData();
                if (viewer != null) {
                    PaletteView.this.updateSiteSelection((IStructuredSelection)viewer.getSelection());
                } else {
                    PaletteView.this.getViewSite().getSelectionProvider().setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        });
    }

    public void setFocus() {
        this.shelf.setFocus();
    }

    protected void createItems() {
        Image image;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipsetrader.ui.indicators");
        IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
        ArrayList<IConfigurationElement> contributionElements = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> categories = new ArrayList<IConfigurationElement>();
        int i = 0;
        while (i < configElements.length) {
            if (configElements[i].getName().equals(K_CATEGORY)) {
                categories.add(configElements[i]);
            } else {
                contributionElements.add(configElements[i]);
            }
            ++i;
        }
        for (IConfigurationElement categoryElement : categories) {
            PShelfItem shelfItem = new PShelfItem(this.shelf, 0);
            shelfItem.setText(categoryElement.getAttribute(K_NAME));
            String icon = categoryElement.getAttribute(K_ICON);
            if (icon != null) {
                Image image2;
                ImageDescriptor imageDescriptor = ChartsUIActivator.imageDescriptorFromPlugin((String)categoryElement.getContributor().getName(), (String)icon);
                Image image3 = image2 = imageDescriptor != null ? imageDescriptor.createImage() : null;
                if (image2 != null) {
                    shelfItem.setImage(image2);
                    shelfItem.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            image2.dispose();
                        }
                    });
                }
            }
            List<IConfigurationElement> addedElements = this.createContents(shelfItem, contributionElements.toArray(new IConfigurationElement[contributionElements.size()]), categoryElement.getAttribute(K_ID));
            contributionElements.removeAll(addedElements);
        }
        PShelfItem shelfItem = new PShelfItem(this.shelf, 0);
        shelfItem.setText(Messages.PaletteView_OtherTitle);
        ImageDescriptor imageDescriptor = ChartsUIActivator.imageDescriptorFromPlugin("icons/obj16/blank_obj.gif");
        Image image4 = image = imageDescriptor != null ? imageDescriptor.createImage() : null;
        if (image != null) {
            shelfItem.setImage(image);
            shelfItem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    image.dispose();
                }
            });
        }
        this.createContents(shelfItem, contributionElements.toArray(new IConfigurationElement[contributionElements.size()]), null);
    }

    protected List<IConfigurationElement> createContents(PShelfItem shelfItem, IConfigurationElement[] configElements, String categoryId) {
        shelfItem.getBody().setLayout((Layout)new FillLayout());
        final TableViewer viewer = new TableViewer(shelfItem.getBody(), 65538);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private Map<Object, Image> imageMap = new HashMap<Object, Image>();

            public Image getImage(Object element) {
                IConfigurationElement configurationElement;
                String icon;
                Image image = this.imageMap.get(element);
                if (image == null && (icon = (configurationElement = (IConfigurationElement)element).getAttribute(PaletteView.K_ICON)) != null) {
                    ImageDescriptor imageDescriptor = ChartsUIActivator.imageDescriptorFromPlugin((String)configurationElement.getContributor().getName(), (String)icon);
                    image = imageDescriptor != null ? imageDescriptor.createImage() : null;
                    this.imageMap.put(element, image);
                }
                return image;
            }

            public void dispose() {
                for (Image image : this.imageMap.values()) {
                    image.dispose();
                }
                super.dispose();
            }

            public String getText(Object element) {
                IConfigurationElement configurationElement = (IConfigurationElement)element;
                String template = configurationElement.getAttribute(PaletteView.K_DESCRIPTION) != null ? "{0} - {1}" : "{0}";
                return NLS.bind((String)template, (Object[])new Object[]{configurationElement.getAttribute(PaletteView.K_NAME), configurationElement.getAttribute(PaletteView.K_DESCRIPTION)});
            }
        });
        viewer.setSorter(new ViewerSorter());
        shelfItem.setData((Object)viewer);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PaletteView.this.updateSiteSelection((IStructuredSelection)event.getSelection());
            }
        });
        Transfer[] transferTypes = new Transfer[]{ChartObjectFactoryTransfer.getInstance()};
        viewer.addDragSupport(3, transferTypes, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                event.doit = !viewer.getSelection().isEmpty();
            }

            public void dragSetData(DragSourceEvent event) {
                Object[] selection = ((IStructuredSelection)viewer.getSelection()).toArray();
                String[] elements = new String[selection.length];
                int i = 0;
                while (i < elements.length) {
                    elements[i] = ((IConfigurationElement)selection[i]).getAttribute(PaletteView.K_ID);
                    ++i;
                }
                event.data = elements;
            }
        });
        ArrayList<IConfigurationElement> input = new ArrayList<IConfigurationElement>();
        int i = 0;
        while (i < configElements.length) {
            if (categoryId == null || categoryId.equals(configElements[i].getAttribute(K_CATEGORY))) {
                input.add(configElements[i]);
            }
            ++i;
        }
        viewer.setInput((Object)input.toArray());
        return input;
    }

    protected void updateSiteSelection(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            Object[] ar = selection.toArray();
            Object[] o = new Object[ar.length];
            int i = 0;
            while (i < o.length) {
                try {
                    o[i] = ((IConfigurationElement)ar[i]).createExecutableExtension("class");
                }
                catch (Exception exception) {}
                ++i;
            }
            this.getViewSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(o));
        } else {
            this.getViewSite().getSelectionProvider().setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }
}

