/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import java.util.Observable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipsetrader.ui.internal.charts.views.MainRenderStyle;

public class MainRenderStyleInput
extends Observable {
    private Label label;
    private ComboViewer combo;

    public MainRenderStyleInput(Composite parent) {
        this(parent, null);
    }

    public MainRenderStyleInput(Composite parent, String text) {
        if (text != null) {
            this.label = new Label(parent, 0);
            this.label.setText(text);
        }
        this.initializeCombo(parent);
    }

    protected void initializeCombo(Composite parent) {
        this.combo = new ComboViewer(parent, 8);
        this.combo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.combo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.combo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MainRenderStyleInput.this.setChanged();
                MainRenderStyleInput.this.notifyObservers(event.getSelection());
            }
        });
        this.combo.setInput((Object)MainRenderStyle.values());
    }

    public void setSelection(MainRenderStyle selection) {
        this.combo.setSelection((ISelection)(selection != null ? new StructuredSelection((Object)selection) : StructuredSelection.EMPTY));
    }

    public MainRenderStyle getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.combo.getSelection();
        return selection.isEmpty() ? null : (MainRenderStyle)((Object)selection.getFirstElement());
    }

    public String getText() {
        return this.label != null ? this.label.getText() : "";
    }

    public void setText(String text) {
        if (this.label != null) {
            this.label.setText(text);
        }
    }

    public Label getLabel() {
        return this.label;
    }

    public ComboViewer getViewer() {
        return this.combo;
    }

    public Combo getCombo() {
        return this.combo.getCombo();
    }

    public void setEnabled(boolean enabled) {
        if (this.label != null) {
            this.label.setEnabled(enabled);
        }
        this.combo.getControl().setEnabled(enabled);
    }

    public boolean getEnabled() {
        return this.combo.getControl().getEnabled();
    }

    public boolean isEnabled() {
        return this.combo.getControl().isEnabled();
    }
}

