/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.ui.internal.charts.views.MainChartFactory;
import org.eclipsetrader.ui.internal.charts.views.MainRenderStyleInput;

public class MainPropertiesPage
extends PropertyPage {
    private MainRenderStyleInput style;
    private Button override;
    private ColorSelector lineColor;
    private ColorSelector barPositiveColor;
    private ColorSelector barNegativeColor;
    private ColorSelector candleOutlineColor;
    private ColorSelector candlePositiveColor;
    private ColorSelector candleNegativeColor;

    public MainPropertiesPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setTitle("General");
        Label label = new Label(content, 0);
        label.setText("Style");
        this.style = new MainRenderStyleInput(content);
        this.style.getCombo().setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        ((GridData)label.getLayoutData()).heightHint = this.convertVerticalDLUsToPixels(5);
        this.override = new Button(content, 32);
        this.override.setText("Override color theme");
        this.override.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        this.override.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainPropertiesPage.this.updateControlsEnablement();
            }
        });
        label = new Label(content, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        label = new Label(content, 0);
        label.setText("Line");
        this.lineColor = new ColorSelector(content);
        this.lineColor.setColorValue(new RGB(0, 0, 255));
        this.lineColor.getButton().setData("label", (Object)label);
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label = new Label(content, 0);
        label.setText("Bars");
        this.barPositiveColor = new ColorSelector(content);
        this.barPositiveColor.setColorValue(new RGB(0, 255, 0));
        this.barPositiveColor.getButton().setData("label", (Object)label);
        label = new Label(content, 0);
        label.setText("Positive");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.barPositiveColor.getButton().setData("label2", (Object)label);
        label = new Label(content, 0);
        this.barNegativeColor = new ColorSelector(content);
        this.barNegativeColor.setColorValue(new RGB(255, 0, 0));
        this.barNegativeColor.getButton().setData("label", (Object)label);
        label = new Label(content, 0);
        label.setText("Negative");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.barNegativeColor.getButton().setData("label2", (Object)label);
        label = new Label(content, 0);
        label.setText("Candles");
        this.candlePositiveColor = new ColorSelector(content);
        this.candlePositiveColor.setColorValue(new RGB(0, 255, 0));
        this.candlePositiveColor.getButton().setData("label", (Object)label);
        label = new Label(content, 0);
        label.setText("Positive");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.candlePositiveColor.getButton().setData("label2", (Object)label);
        label = new Label(content, 0);
        this.candleNegativeColor = new ColorSelector(content);
        this.candleNegativeColor.setColorValue(new RGB(255, 0, 0));
        this.candleNegativeColor.getButton().setData("label", (Object)label);
        label = new Label(content, 0);
        label.setText("Negative");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.candleNegativeColor.getButton().setData("label2", (Object)label);
        label = new Label(content, 0);
        this.candleOutlineColor = new ColorSelector(content);
        this.candleOutlineColor.setColorValue(new RGB(0, 0, 0));
        this.candleOutlineColor.getButton().setData("label", (Object)label);
        label = new Label(content, 0);
        label.setText("Outline");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.candleOutlineColor.getButton().setData("label2", (Object)label);
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        MainChartFactory object = (MainChartFactory)this.getElement().getAdapter(MainChartFactory.class);
        this.style.setSelection(object.getStyle());
        boolean isOverride = false;
        if (object.getLineColor() != null) {
            isOverride = true;
        } else if (object.getBarPositiveColor() != null) {
            isOverride = true;
        } else if (object.getBarNegativeColor() != null) {
            isOverride = true;
        } else if (object.getCandlePositiveColor() != null) {
            isOverride = true;
        } else if (object.getCandleNegativeColor() != null) {
            isOverride = true;
        } else if (object.getCandleOutlineColor() != null) {
            isOverride = true;
        }
        this.override.setSelection(isOverride);
        if (object.getLineColor() != null) {
            this.lineColor.setColorValue(object.getLineColor());
        }
        if (object.getBarPositiveColor() != null) {
            this.barPositiveColor.setColorValue(object.getBarPositiveColor());
        }
        if (object.getBarNegativeColor() != null) {
            this.barNegativeColor.setColorValue(object.getBarNegativeColor());
        }
        if (object.getCandlePositiveColor() != null) {
            this.candlePositiveColor.setColorValue(object.getCandlePositiveColor());
        }
        if (object.getCandleNegativeColor() != null) {
            this.candleNegativeColor.setColorValue(object.getCandleNegativeColor());
        }
        if (object.getCandleOutlineColor() != null) {
            this.candleOutlineColor.setColorValue(object.getCandleOutlineColor());
        }
        this.updateControlsEnablement();
        super.performDefaults();
    }

    public boolean performOk() {
        MainChartFactory object = (MainChartFactory)this.getElement().getAdapter(MainChartFactory.class);
        object.setStyle(this.style.getSelection());
        object.setLineColor(this.override.getSelection() ? this.lineColor.getColorValue() : null);
        object.setBarPositiveColor(this.override.getSelection() ? this.barPositiveColor.getColorValue() : null);
        object.setBarNegativeColor(this.override.getSelection() ? this.barNegativeColor.getColorValue() : null);
        object.setCandlePositiveColor(this.override.getSelection() ? this.candlePositiveColor.getColorValue() : null);
        object.setCandleNegativeColor(this.override.getSelection() ? this.candleNegativeColor.getColorValue() : null);
        object.setCandleOutlineColor(this.override.getSelection() ? this.candleOutlineColor.getColorValue() : null);
        return super.performOk();
    }

    protected void updateControlsEnablement() {
        this.lineColor.setEnabled(this.override.getSelection());
        ((Label)this.lineColor.getButton().getData("label")).setEnabled(this.override.getSelection());
        this.barPositiveColor.setEnabled(this.override.getSelection());
        ((Label)this.barPositiveColor.getButton().getData("label")).setEnabled(this.override.getSelection());
        ((Label)this.barPositiveColor.getButton().getData("label2")).setEnabled(this.override.getSelection());
        this.barNegativeColor.setEnabled(this.override.getSelection());
        ((Label)this.barNegativeColor.getButton().getData("label")).setEnabled(this.override.getSelection());
        ((Label)this.barNegativeColor.getButton().getData("label2")).setEnabled(this.override.getSelection());
        this.candlePositiveColor.setEnabled(this.override.getSelection());
        ((Label)this.candlePositiveColor.getButton().getData("label")).setEnabled(this.override.getSelection());
        ((Label)this.candlePositiveColor.getButton().getData("label2")).setEnabled(this.override.getSelection());
        this.candleNegativeColor.setEnabled(this.override.getSelection());
        ((Label)this.candleNegativeColor.getButton().getData("label")).setEnabled(this.override.getSelection());
        ((Label)this.candleNegativeColor.getButton().getData("label2")).setEnabled(this.override.getSelection());
        this.candleOutlineColor.setEnabled(this.override.getSelection());
        ((Label)this.candleOutlineColor.getButton().getData("label")).setEnabled(this.override.getSelection());
        ((Label)this.candleOutlineColor.getButton().getData("label2")).setEnabled(this.override.getSelection());
    }
}

