/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipsetrader.ui.internal.charts.ChartsUIActivator;
import org.eclipsetrader.ui.internal.charts.views.Messages;

public class GeneralPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button showTooltips;
    private Button showScaleTooltips;
    private Button showCrosshair;
    private Spinner marketDepth;
    private Button showPriceVolume;
    private Group croshairActivationGroup;
    private Button onMouseDown;
    private Button onMouseHover;
    private Button showSummaryTooltip;

    public GeneralPreferencesPage() {
        super(Messages.GeneralPreferencesPage_Title);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(ChartsUIActivator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(2);
        content.setLayout((Layout)gridLayout);
        this.showTooltips = new Button(content, 32);
        this.showTooltips.setText(Messages.GeneralPreferencesPage_ShowTooltipsLabel);
        this.showTooltips.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.showScaleTooltips = new Button(content, 32);
        this.showScaleTooltips.setText(Messages.GeneralPreferencesPage_ShowScaleTooltipsLabel);
        this.showScaleTooltips.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.showCrosshair = new Button(content, 32);
        this.showCrosshair.setText(Messages.GeneralPreferencesPage_ShowCrosshairLabel);
        this.showCrosshair.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.showCrosshair.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPreferencesPage.this.updateButtonsEnablement();
            }
        });
        this.croshairActivationGroup = new Group(content, 0);
        this.croshairActivationGroup.setText(Messages.GeneralPreferencesPage_CrosshairModeLabel);
        this.croshairActivationGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(2);
        this.croshairActivationGroup.setLayout((Layout)gridLayout);
        this.onMouseDown = new Button((Composite)this.croshairActivationGroup, 16);
        this.onMouseDown.setText(Messages.GeneralPreferencesPage_OneMouseClickLabel);
        this.onMouseDown.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.onMouseHover = new Button((Composite)this.croshairActivationGroup, 16);
        this.onMouseHover.setText(Messages.GeneralPreferencesPage_OnMouseHoverLabel);
        this.onMouseHover.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.showSummaryTooltip = new Button((Composite)this.croshairActivationGroup, 32);
        this.showSummaryTooltip.setText(Messages.GeneralPreferencesPage_ShowSummaryTooltipLabel);
        this.showSummaryTooltip.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        Label lbl = new Label(content, 0);
        lbl.setText("Market Depth Levels");
        this.marketDepth = new Spinner(content, 2048);
        this.marketDepth.setValues(5, 1, 10, 0, 1, 10);
        this.showPriceVolume = new Button(content, 32);
        this.showPriceVolume.setText("Show Price/Volume on market depth");
        this.showPriceVolume.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.performDefaults();
        return content;
    }

    protected void updateButtonsEnablement() {
        boolean enable = this.showCrosshair.getSelection();
        this.croshairActivationGroup.setEnabled(enable);
        this.onMouseDown.setEnabled(enable);
        this.onMouseHover.setEnabled(enable);
        this.showSummaryTooltip.setEnabled(enable);
    }

    protected void performDefaults() {
        IPreferenceStore preferences = this.getPreferenceStore();
        this.showTooltips.setSelection(preferences.getBoolean("SHOW_TOOLTIPS"));
        this.showScaleTooltips.setSelection(preferences.getBoolean("SHOW_SCALE_TOOLTIPS"));
        int v = preferences.getInt("CROSSHAIR_ACTIVATION");
        this.showCrosshair.setSelection(v != 0);
        this.onMouseDown.setSelection(v == 0 || v == 1);
        this.onMouseHover.setSelection(v == 2);
        this.showSummaryTooltip.setSelection(preferences.getBoolean("CROSSHAIR_SUMMARY_TOOLTIP"));
        this.marketDepth.setSelection(preferences.getInt("MARKET_DEPTH_LEVELS"));
        this.showPriceVolume.setSelection(preferences.getBoolean("SHOW_PRICE_VOLUME"));
        this.updateButtonsEnablement();
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore preferences = this.getPreferenceStore();
        preferences.setValue("SHOW_TOOLTIPS", this.showTooltips.getSelection());
        preferences.setValue("SHOW_SCALE_TOOLTIPS", this.showScaleTooltips.getSelection());
        if (this.showCrosshair.getSelection()) {
            if (this.onMouseDown.getSelection()) {
                preferences.setValue("CROSSHAIR_ACTIVATION", 1);
            }
            if (this.onMouseHover.getSelection()) {
                preferences.setValue("CROSSHAIR_ACTIVATION", 2);
            }
        } else {
            preferences.setValue("CROSSHAIR_ACTIVATION", 0);
        }
        preferences.setValue("CROSSHAIR_SUMMARY_TOOLTIP", this.showSummaryTooltip.getSelection());
        preferences.setValue("MARKET_DEPTH_LEVELS", this.marketDepth.getSelection());
        preferences.setValue("SHOW_PRICE_VOLUME", this.showPriceVolume.getSelection());
        return super.performOk();
    }
}

