/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.ui.internal.charts.views.Messages;

public class CustomPeriodDialog
extends Dialog {
    private CDateTime from;
    private CDateTime to;
    private ComboViewer resolution;
    private Date firstDate;
    private Date lastDate;
    private TimeSpan resolutionTimeSpan;

    public CustomPeriodDialog(Shell parentShell, Date firstDate, Date lastDate) {
        super(parentShell);
        this.firstDate = firstDate;
        this.lastDate = lastDate;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CustomPeriodDialog_CustomPeriodTitle);
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(content, 0);
        label.setText(Messages.CustomPeriodDialog_BeginDateLabel);
        this.from = new CDateTime(content, 0x100003);
        label = new Label(content, 0);
        label.setText(Messages.CustomPeriodDialog_EndDateLabel);
        this.to = new CDateTime(content, 0x100003);
        label = new Label(content, 0);
        label.setText(Messages.CustomPeriodDialog_ResolutionLabel);
        this.resolution = new ComboViewer(content, 12);
        this.resolution.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.resolution.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.resolution.setSorter(new ViewerSorter());
        this.resolution.setInput((Object)new Object[]{TimeSpan.days((int)1), TimeSpan.minutes((int)1), TimeSpan.minutes((int)5), TimeSpan.minutes((int)10), TimeSpan.minutes((int)15), TimeSpan.minutes((int)30), TimeSpan.minutes((int)60)});
        this.from.setSelection(this.firstDate);
        this.to.setSelection(this.lastDate);
        this.resolution.setSelection((ISelection)new StructuredSelection((Object)this.resolutionTimeSpan));
        return content;
    }

    protected void okPressed() {
        this.firstDate = this.from.getSelection();
        this.lastDate = this.to.getSelection();
        this.resolutionTimeSpan = (TimeSpan)((IStructuredSelection)this.resolution.getSelection()).getFirstElement();
        super.okPressed();
    }

    public Date getFirstDate() {
        return this.firstDate;
    }

    public Date getLastDate() {
        return this.lastDate;
    }
}

