/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import java.text.NumberFormat;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.ui.charts.ChartObjectFocusEvent;
import org.eclipsetrader.ui.charts.DataBounds;
import org.eclipsetrader.ui.charts.Graphics;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectVisitor;
import org.eclipsetrader.ui.charts.IGraphics;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.FeedMonitor;
import pk.com.softech.tradingterminal.core.db.Security;

public class CurrentPriceLine
extends Observable
implements IChartObject,
IAdaptable,
Observer {
    private double lastTrade;
    private Security security;
    private RGB foreground = Display.getDefault().getSystemColor(28).getRGB();
    private RGB background = Display.getDefault().getSystemColor(29).getRGB();
    private RGB gray = Display.getDefault().getSystemColor(15).getRGB();
    private int width;
    private NumberFormat numberFormat = CorePlugin.getPriceFormatter();

    public void setSecurity(Security sec) {
        if (this.security != null) {
            this.security.getQuoteMonitor().deleteObserver((Observer)this);
            FeedMonitor.cancelMonitor((Security)this.security);
        }
        if (sec != null) {
            sec.getQuoteMonitor().addObserver((Observer)this);
            FeedMonitor.monitor((Security)sec);
            this.lastTrade = sec.getQuote().getLast();
        } else {
            this.lastTrade = -1.0;
        }
        this.security = sec;
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void accept(IChartObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return false;
    }

    @Override
    public IDataSeries getDataSeries() {
        return null;
    }

    @Override
    public String getToolTip() {
        return null;
    }

    @Override
    public String getToolTip(int x, int y) {
        return null;
    }

    @Override
    public void handleFocusGained(ChartObjectFocusEvent event) {
    }

    @Override
    public void handleFocusLost(ChartObjectFocusEvent event) {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void paint(IGraphics graphics) {
        graphics.setForegroundColor(this.gray);
        graphics.setBackgroundColor(this.background);
        int y = graphics.mapToVerticalAxis(this.lastTrade);
        graphics.drawLine(0, y, this.width, y);
    }

    @Override
    public void paintScale(Graphics graphics) {
        graphics.setForegroundColor(this.foreground);
        graphics.setBackgroundColor(this.background);
        String text = this.numberFormat.format(this.lastTrade);
        Point extents = graphics.stringExtent(text);
        int y = graphics.mapToVerticalAxis(this.lastTrade) - extents.y / 2;
        graphics.fillRectangle(0, y, extents.x, extents.y);
        graphics.drawString(text, 0, y);
    }

    @Override
    public void setDataBounds(DataBounds bounds) {
        this.width = bounds.width;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.lastTrade = this.security != null ? this.security.getQuote().getLast() : -1.0;
    }
}

