/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import java.text.NumberFormat;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.ui.charts.ChartObjectFocusEvent;
import org.eclipsetrader.ui.charts.DataBounds;
import org.eclipsetrader.ui.charts.Graphics;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectVisitor;
import org.eclipsetrader.ui.charts.IGraphics;
import org.eclipsetrader.ui.charts.Util;
import org.eclipsetrader.ui.internal.charts.ChartsUIActivator;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Level2FeedMonitor;
import pk.com.softech.tradingterminal.core.db.Level2;
import pk.com.softech.tradingterminal.core.db.Level2Ask;
import pk.com.softech.tradingterminal.core.db.Level2Bid;
import pk.com.softech.tradingterminal.core.db.Security;

public class CurrentBook
extends Observable
implements IChartObject,
IAdaptable,
Observer {
    Security security;
    int width;
    int height;
    int boxWidth = 50;
    long biggestQuantity;
    int marketDepth = ChartsUIActivator.getDefault().getPreferenceStore().getInt("MARKET_DEPTH_LEVELS");
    boolean showPriceVolume = ChartsUIActivator.getDefault().getPreferenceStore().getBoolean("SHOW_PRICE_VOLUME");
    RGB bidForeground = new RGB(0, 254, 0);
    RGB askForeground = new RGB(254, 0, 0);
    RGB bidBackground;
    RGB askBackground;
    NumberFormat numberFormat = CorePlugin.getNumberFormatter();
    NumberFormat priceFormat = CorePlugin.getPriceFormatter();

    public CurrentBook() {
        ChartsUIActivator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                IPreferenceStore store;
                if (event.getProperty().equals("MARKET_DEPTH_LEVELS")) {
                    store = (IPreferenceStore)event.getSource();
                    CurrentBook.this.marketDepth = store.getInt("MARKET_DEPTH_LEVELS");
                }
                if (event.getProperty().equals("SHOW_PRICE_VOLUME")) {
                    store = (IPreferenceStore)event.getSource();
                    CurrentBook.this.showPriceVolume = store.getBoolean("SHOW_PRICE_VOLUME");
                }
            }
        });
    }

    public void setSecurity(Security sec) {
        if (this.security != null) {
            this.security.getLevel2Monitor().deleteObserver((Observer)this);
            Level2FeedMonitor.cancelMonitor((Security)this.security);
        }
        if (sec != null) {
            sec.getLevel2Monitor().addObserver((Observer)this);
            Level2FeedMonitor.monitor((Security)sec);
        }
        this.security = sec;
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void accept(IChartObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return false;
    }

    @Override
    public IDataSeries getDataSeries() {
        return null;
    }

    @Override
    public String getToolTip() {
        return null;
    }

    @Override
    public String getToolTip(int x, int y) {
        return null;
    }

    @Override
    public void handleFocusGained(ChartObjectFocusEvent event) {
    }

    @Override
    public void handleFocusLost(ChartObjectFocusEvent event) {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void paint(IGraphics graphics) {
        int x1;
        Point vol;
        String price;
        String quantity;
        int x;
        int w;
        if (this.security == null) {
            return;
        }
        Level2Bid bid = (Level2Bid)this.security.getLevel2BidMBO();
        Level2Ask ask = (Level2Ask)this.security.getLevel2AskMBO();
        if (bid == null || ask == null) {
            return;
        }
        if (bid.size() == 0 && ask.size() == 0) {
            return;
        }
        this.calculateBiggestQuantity();
        if (this.biggestQuantity == 0L) {
            return;
        }
        int verticalCenter = 0;
        if (this.security != null && this.security.getQuote() != null) {
            verticalCenter = graphics.mapToVerticalAxis(this.security.getQuote().getLast());
        } else if (bid.size() != 0 && ask.size() != 0) {
            double middle = (ask.get((int)0).price + bid.get((int)0).price) / 2.0;
            verticalCenter = graphics.mapToVerticalAxis(middle);
        } else if (bid.size() != 0) {
            verticalCenter = graphics.mapToVerticalAxis(bid.get((int)0).price);
        } else if (ask.size() != 0) {
            verticalCenter = graphics.mapToVerticalAxis(ask.get((int)0).price);
        }
        this.bidBackground = Util.blend(this.bidForeground, graphics.getBackgroundColor(), 25);
        this.askBackground = Util.blend(this.askForeground, graphics.getBackgroundColor(), 25);
        Point extents = graphics.stringExtent(this.numberFormat.format(this.biggestQuantity));
        int y = verticalCenter + extents.y + 2;
        int i = 0;
        while (i < this.marketDepth && i < bid.size()) {
            w = this.getBarWidth(bid.get(i));
            x = this.width - w - 10;
            graphics.setForegroundColor(this.bidForeground);
            graphics.setBackgroundColor(this.bidBackground);
            graphics.fillRectangle(x, y - extents.y + 2, w, extents.y - 4);
            graphics.drawRectangle(x, y - extents.y + 2, w, extents.y - 4);
            if (this.showPriceVolume) {
                quantity = this.numberFormat.format(bid.get((int)i).quantity);
                price = this.priceFormat.format(bid.get((int)i).price);
                vol = graphics.stringExtent(String.valueOf(quantity) + price);
                x1 = this.width - w - vol.x - 20;
                graphics.drawString("(" + price + ")" + quantity, x1, y - extents.y);
            }
            y += extents.y + 4;
            ++i;
        }
        y = verticalCenter - 2;
        i = 0;
        while (i < this.marketDepth && i < ask.size()) {
            w = this.getBarWidth(ask.get(i));
            x = this.width - w - 10;
            graphics.setForegroundColor(this.askForeground);
            graphics.setBackgroundColor(this.askBackground);
            graphics.fillRectangle(x, y - extents.y + 2, w, extents.y - 4);
            graphics.drawRectangle(x, y - extents.y + 2, w, extents.y - 4);
            if (this.showPriceVolume) {
                quantity = this.numberFormat.format(ask.get((int)i).quantity);
                price = this.priceFormat.format(ask.get((int)i).price);
                vol = graphics.stringExtent(String.valueOf(quantity) + price);
                x1 = this.width - w - vol.x - 20;
                graphics.drawString("(" + price + ")" + quantity, x1, y - extents.y);
            }
            y -= extents.y + 4;
            ++i;
        }
    }

    @Override
    public void paintScale(Graphics graphics) {
    }

    @Override
    public void setDataBounds(DataBounds bounds) {
        this.width = bounds.width;
        this.height = bounds.height;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    void calculateBiggestQuantity() {
        this.biggestQuantity = 0L;
        Level2Bid bid = (Level2Bid)this.security.getLevel2BidMBO();
        int i = 0;
        while (i < bid.size() && i < this.marketDepth) {
            this.biggestQuantity = Math.max(this.biggestQuantity, (long)bid.get((int)i).quantity);
            ++i;
        }
        Level2Ask ask = (Level2Ask)this.security.getLevel2AskMBO();
        int i2 = 0;
        while (i2 < ask.size() && i2 < this.marketDepth) {
            this.biggestQuantity = Math.max(this.biggestQuantity, (long)ask.get((int)i2).quantity);
            ++i2;
        }
    }

    int getBarWidth(Level2.Item entry) {
        return (int)((float)entry.quantity / (float)this.biggestQuantity * (float)this.boxWidth);
    }

    @Override
    public void update(Observable o, Object arg1) {
        if (this.security != null) {
            this.security.getLevel2Monitor();
        }
    }
}

