/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.ViewPart;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.OHLCDataSeries;
import org.eclipsetrader.core.charts.repository.IChartTemplate;
import org.eclipsetrader.core.feed.History;
import org.eclipsetrader.core.feed.HistoryDay;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.OHLC;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.charts.repository.ChartTemplate;
import org.eclipsetrader.ui.charts.BaseChartViewer;
import org.eclipsetrader.ui.charts.ChartCanvas;
import org.eclipsetrader.ui.charts.ChartObjectFactoryTransfer;
import org.eclipsetrader.ui.charts.ChartRowViewItem;
import org.eclipsetrader.ui.charts.ChartView;
import org.eclipsetrader.ui.charts.ChartViewItem;
import org.eclipsetrader.ui.charts.IChartEditorListener;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.internal.charts.ChartsUIActivator;
import org.eclipsetrader.ui.internal.charts.DataImportJob;
import org.eclipsetrader.ui.internal.charts.views.ChartLoadJob;
import org.eclipsetrader.ui.internal.charts.views.ChartViewDropTarget;
import org.eclipsetrader.ui.internal.charts.views.ChartViewItemFinder;
import org.eclipsetrader.ui.internal.charts.views.CurrentBookFactory;
import org.eclipsetrader.ui.internal.charts.views.CurrentPriceLineFactory;
import org.eclipsetrader.ui.internal.charts.views.MainChartFactory;
import org.eclipsetrader.ui.internal.charts.views.Messages;
import org.eclipsetrader.ui.internal.charts.views.PeriodAction;
import org.eclipsetrader.ui.internal.charts.views.SelectionProvider;
import org.eclipsetrader.ui.internal.charts.views.TemplateAction;
import org.eclipsetrader.ui.internal.charts.views.ToolAction;
import org.osgi.framework.Bundle;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.FeedMonitor;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.feed.Quote;
import pk.com.softech.tradingterminal.core.ui.actions.CopyAction;
import pk.com.softech.tradingterminal.core.ui.actions.CutAction;
import pk.com.softech.tradingterminal.core.ui.actions.DeleteAction;
import pk.com.softech.tradingterminal.core.ui.actions.PasteAction;
import pk.com.softech.tradingterminal.core.views.IViewChangeListener;
import pk.com.softech.tradingterminal.core.views.IViewItem;
import pk.com.softech.tradingterminal.core.views.ViewEvent;

public class ChartViewPart
extends ViewPart
implements ISaveablePart,
ICollectionObserver,
Observer {
    public static final String VIEW_ID = "org.eclipsetrader.ui.chart";
    public static final String K_VIEWS = "Views";
    public static final String K_URI = "uri";
    public static final String K_TEMPLATE = "Basic-Template";
    public static final String[] TEMPLATES = new String[]{"Basic-Template", "Advanced-Template", "Research-Template"};
    public static final String K_TEMPLATE_TYPE = "Template-Type";
    public static final String K_PRIVATE_TEMPLATE = "private-template";
    public static final String K_WEIGHTS = "weights";
    public static final String K_PERIOD = "period";
    public static final String K_RESOLUTION = "resolution";
    public static final String K_SHOW_TOOLTIPS = "show-tooltips";
    public static final String K_ZOOM_FACTOR = "zoom-factor";
    public static final String K_SHOW_CURRENT_PRICE = "show-current-price";
    public static final String K_SHOW_CURRENT_BOOK = "show-current-book";
    private Security security;
    private IChartTemplate template;
    BaseChartViewer viewer;
    private ChartView view;
    private IHistory history;
    private ChartViewDropTarget dropListener;
    private boolean dirty;
    private IDialogSettings dialogSettings;
    private Action updateAction;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Action deleteAction;
    private Action propertiesAction;
    private Action zoomOutAction;
    private Action zoomInAction;
    private Action zoomResetAction;
    private Action chartsPallateAction;
    private TemplateAction[] templateActions;
    private Action resetChart;
    private Action fitChart;
    private PeriodAction periodAllAction;
    private PeriodAction[] periodAction;
    private Action deleteChartAction;
    private Action currentPriceLineAction;
    private CurrentPriceLineFactory currentPriceLineFactory;
    private Action currentBookAction;
    private CurrentBookFactory currentBookFactory;
    Date lastFeedDate = null;
    IMemento memento;
    IPreferenceStore preferenceStore;
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(java.beans.PropertyChangeEvent evt) {
            "bars".equals(evt.getPropertyName());
        }
    };
    private IViewChangeListener viewChangeListener = new IViewChangeListener(){

        public void viewChanged(ViewEvent event) {
            ChartViewPart.this.scheduleLoadJob(false, false);
            ChartViewPart.this.setDirty();
        }
    };
    private IPropertyChangeListener preferenceChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            IPreferenceStore preferences = (IPreferenceStore)event.getSource();
            if ("SHOW_TOOLTIPS".equals(event.getProperty())) {
                ChartViewPart.this.viewer.setShowTooltips(preferences.getBoolean("SHOW_TOOLTIPS"));
            }
            if ("SHOW_SCALE_TOOLTIPS".equals(event.getProperty())) {
                ChartViewPart.this.viewer.setShowScaleTooltips(preferences.getBoolean("SHOW_SCALE_TOOLTIPS"));
            }
            if ("CROSSHAIR_ACTIVATION".equals(event.getProperty())) {
                ChartViewPart.this.viewer.setCrosshairMode(preferences.getInt("CROSSHAIR_ACTIVATION"));
            }
            if ("CROSSHAIR_SUMMARY_TOOLTIP".equals(event.getProperty())) {
                ChartViewPart.this.viewer.setDecoratorSummaryTooltips(preferences.getBoolean("CROSSHAIR_SUMMARY_TOOLTIP"));
            }
        }
    };
    private Action printAction = new Action(Messages.ChartViewPart_PrintAction){

        public void run() {
            PrintDialog dialog = new PrintDialog(ChartViewPart.this.getViewSite().getShell(), 0);
            PrinterData data = dialog.open();
            if (data == null) {
                return;
            }
            if (data.printToFile) {
                data.fileName = "print.out";
            }
            Printer printer = new Printer(data);
            try {
                try {
                    if (printer.startJob(ChartViewPart.this.getPartName())) {
                        ChartViewPart.this.viewer.print(printer);
                        printer.endJob();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    printer.dispose();
                }
            }
            finally {
                printer.dispose();
            }
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        this.memento = memento;
        this.preferenceStore = ChartsUIActivator.getDefault().getPreferenceStore();
        try {
            this.dialogSettings = ChartsUIActivator.getDefault().getDialogSettings().getSection(K_VIEWS).getSection(site.getSecondaryId());
            String securityId = this.dialogSettings.get(K_URI);
            if (securityId == null) {
                securityId = site.getSecondaryId();
            }
            this.security = (Security)CorePlugin.getRepository().load(Security.class, securityId);
            int i = 0;
            while (i < TEMPLATES.length) {
                if (this.dialogSettings.get(TEMPLATES[i]) == null) {
                    this.dialogSettings = ChartsUIActivator.getDefault().getDialogSettingsForView(new URI(this.security.getId()));
                    break;
                }
                ++i;
            }
            try {
                String privateTemplate = this.dialogSettings.get(K_PRIVATE_TEMPLATE);
                if (privateTemplate != null) {
                    this.template = this.unmarshal(privateTemplate);
                }
            }
            catch (Exception exception) {}
            if (this.template == null) {
                IPath templatePath = new Path("data").append(this.dialogSettings.get(K_TEMPLATE));
                InputStream stream = FileLocator.openStream((Bundle)ChartsUIActivator.getDefault().getBundle(), (IPath)templatePath, (boolean)false);
                this.template = this.unmarshal(stream);
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.ui.charts", String.valueOf(Messages.ChartViewPart_LoadingErrorMessage) + site.getSecondaryId(), (Throwable)e);
            ChartsUIActivator.getDefault().getLog().log((IStatus)status);
        }
        site.setSelectionProvider((ISelectionProvider)new SelectionProvider());
        this.createActions();
        IActionBars actionBars = site.getActionBars();
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IContributionItem)new Separator("top"));
        menuManager.add((IContributionItem)new GroupMarker("group0"));
        menuManager.add((IContributionItem)new GroupMarker("group1"));
        menuManager.add((IContributionItem)new GroupMarker("group2"));
        menuManager.add((IContributionItem)new GroupMarker("group3"));
        menuManager.add((IContributionItem)new Separator("bottom"));
        menuManager.add((IAction)this.currentPriceLineAction);
        menuManager.add((IAction)this.currentBookAction);
        menuManager.appendToGroup("top", (IAction)this.chartsPallateAction);
        MenuManager templateMenu = new MenuManager("Templates");
        int i = 0;
        while (i < this.templateActions.length) {
            templateMenu.add((IAction)this.templateActions[i]);
            ++i;
        }
        menuManager.appendToGroup("group0", (IContributionItem)templateMenu);
        MenuManager periodMenu = new MenuManager("Chart Period");
        periodMenu.add((IContributionItem)new Separator("periods.top"));
        periodMenu.add((IContributionItem)new Separator("periods"));
        periodMenu.add((IContributionItem)new Separator("periods.bottom"));
        periodMenu.appendToGroup("periods.top", (IAction)this.periodAllAction);
        int i2 = 0;
        while (i2 < this.periodAction.length) {
            periodMenu.appendToGroup("periods", (IAction)this.periodAction[i2]);
            ++i2;
        }
        menuManager.appendToGroup("group1", (IContributionItem)periodMenu);
        menuManager.appendToGroup("bottom", (IAction)this.deleteChartAction);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("periods.top"));
        toolBarManager.add((IContributionItem)new Separator("periods"));
        toolBarManager.add((IContributionItem)new Separator("periods.bottom"));
        toolBarManager.appendToGroup("periods.top", (IAction)this.periodAllAction);
        int i3 = 0;
        while (i3 < Math.min(this.periodAction.length, 5)) {
            toolBarManager.appendToGroup("periods", (IAction)this.periodAction[i3]);
            ++i3;
        }
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IAction)this.fitChart);
        toolBarManager.add((IAction)this.resetChart);
        toolBarManager.add((IAction)this.chartsPallateAction);
        toolBarManager.add((IAction)this.updateAction);
        actionBars.setGlobalActionHandler(this.cutAction.getId(), (IAction)this.cutAction);
        actionBars.setGlobalActionHandler(this.copyAction.getId(), (IAction)this.copyAction);
        actionBars.setGlobalActionHandler(this.pasteAction.getId(), (IAction)this.pasteAction);
        actionBars.setGlobalActionHandler(this.deleteAction.getId(), (IAction)this.deleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)this.printAction);
        ToolAction toolAction = new ToolAction(Messages.ChartViewPart_LineAction, (IViewPart)this, "org.eclipsetrader.ui.charts.tools.line");
        actionBars.setGlobalActionHandler(toolAction.getId(), (IAction)toolAction);
        toolAction = new ToolAction(Messages.ChartViewPart_FiboLineAction, (IViewPart)this, "org.eclipsetrader.ui.charts.tools.fiboline");
        actionBars.setGlobalActionHandler(toolAction.getId(), (IAction)toolAction);
        toolAction = new ToolAction(Messages.ChartViewPart_FanLineAction, (IViewPart)this, "org.eclipsetrader.ui.charts.tools.fanline");
        actionBars.setGlobalActionHandler(toolAction.getId(), (IAction)toolAction);
        toolAction = new ToolAction(Messages.ChartViewPart_FiboArcAction, (IViewPart)this, "org.eclipsetrader.ui.charts.tools.fiboarc");
        actionBars.setGlobalActionHandler(toolAction.getId(), (IAction)toolAction);
        actionBars.setGlobalActionHandler(this.zoomInAction.getActionDefinitionId(), (IAction)this.zoomInAction);
        actionBars.setGlobalActionHandler(this.zoomOutAction.getActionDefinitionId(), (IAction)this.zoomOutAction);
        actionBars.setGlobalActionHandler(this.zoomResetAction.getActionDefinitionId(), (IAction)this.zoomResetAction);
        actionBars.setGlobalActionHandler(this.propertiesAction.getId(), (IAction)this.propertiesAction);
        actionBars.updateActionBars();
    }

    public void saveState(IMemento memento) {
        memento.putInteger(K_ZOOM_FACTOR, this.viewer.getZoomFactor());
        this.saveWeights();
        super.saveState(memento);
    }

    private void saveWeights() {
        int[] weights = this.viewer.getWeights();
        if (weights.length > 1) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < weights.length) {
                if (i != 0) {
                    sb.append(";");
                }
                sb.append(weights[i]);
                ++i;
            }
            this.memento.putString(K_WEIGHTS, sb.toString());
        }
    }

    protected void createActions() {
        ISharedImages sharedImages = this.getViewSite().getWorkbenchWindow().getWorkbench().getSharedImages();
        this.zoomInAction = new Action(Messages.ChartViewPart_ZoomInAction){

            public void run() {
                int factor = ChartViewPart.this.viewer.getZoomFactor();
                ChartViewPart.this.viewer.setZoomFactor(factor + 1);
                ChartViewPart.this.zoomOutAction.setEnabled(true);
                ChartViewPart.this.zoomResetAction.setEnabled(true);
            }
        };
        this.zoomInAction.setId("zoomIn");
        this.zoomInAction.setActionDefinitionId("org.eclipsetrader.ui.charts.zoomIn");
        this.zoomOutAction = new Action(Messages.ChartViewPart_ZoomOutAction){

            public void run() {
                int factor = ChartViewPart.this.viewer.getZoomFactor();
                if (factor > 0) {
                    ChartViewPart.this.viewer.setZoomFactor(factor - 1);
                }
                ChartViewPart.this.zoomOutAction.setEnabled(factor != 1);
                ChartViewPart.this.zoomResetAction.setEnabled(factor != 1);
            }
        };
        this.zoomOutAction.setId("zoomOut");
        this.zoomOutAction.setActionDefinitionId("org.eclipsetrader.ui.charts.zoomOut");
        this.zoomResetAction = new Action(Messages.ChartViewPart_NormalSizeAction){

            public void run() {
                ChartViewPart.this.viewer.setZoomFactor(0);
                ChartViewPart.this.zoomOutAction.setEnabled(false);
                ChartViewPart.this.zoomResetAction.setEnabled(false);
            }
        };
        this.zoomResetAction.setId("zoomReset");
        this.zoomResetAction.setActionDefinitionId("org.eclipsetrader.ui.charts.zoomReset");
        this.zoomOutAction.setEnabled(false);
        this.zoomResetAction.setEnabled(false);
        this.periodAllAction = new PeriodAction(this, Messages.ChartViewPart_AllPeriodAction, null, null, ChartsUIActivator.imageDescriptorFromPlugin("icons/obj16/all.png"));
        this.periodAction = new PeriodAction[]{new PeriodAction(this, TimeSpan.years((int)2), null, ChartsUIActivator.imageDescriptorFromPlugin("icons/obj16/2y.png")), new PeriodAction(this, TimeSpan.years((int)1), null, ChartsUIActivator.imageDescriptorFromPlugin("icons/obj16/1y.png")), new PeriodAction(this, TimeSpan.months((int)6), null, ChartsUIActivator.imageDescriptorFromPlugin("icons/obj16/6m.png")), new PeriodAction(this, TimeSpan.months((int)1), TimeSpan.days((int)1), ChartsUIActivator.imageDescriptorFromPlugin("icons/obj16/1m.png")), new PeriodAction(this, TimeSpan.days((int)1), TimeSpan.minutes((int)1), ChartsUIActivator.imageDescriptorFromPlugin("icons/obj16/1d.png")), new PeriodAction(this, TimeSpan.days((int)1), TimeSpan.minutes((int)2), null), new PeriodAction(this, TimeSpan.days((int)1), TimeSpan.minutes((int)5), null), new PeriodAction(this, TimeSpan.days((int)1), TimeSpan.minutes((int)15), null), new PeriodAction(this, TimeSpan.days((int)1), TimeSpan.minutes((int)30), null)};
        TimeSpan timeSpan = TimeSpan.fromString((String)this.dialogSettings.get(K_PERIOD));
        TimeSpan resolution = TimeSpan.fromString((String)this.dialogSettings.get(K_RESOLUTION));
        this.periodAllAction.setChecked(timeSpan == null);
        int i = 0;
        while (i < this.periodAction.length) {
            if (resolution == null) {
                this.periodAction[i].setChecked(this.periodAction[i].getPeriod().equals((Object)timeSpan));
            } else {
                this.periodAction[i].setChecked(this.periodAction[i].getPeriod().equals((Object)timeSpan) && this.periodAction[i].getResolution().equals((Object)resolution));
            }
            ++i;
        }
        String selectedTemplate = this.dialogSettings.get(K_TEMPLATE_TYPE);
        this.templateActions = new TemplateAction[TEMPLATES.length];
        int i2 = 0;
        while (i2 < TEMPLATES.length) {
            this.templateActions[i2] = new TemplateAction(this, TEMPLATES[i2]);
            this.templateActions[i2].setChecked(selectedTemplate.equals(TEMPLATES[i2]));
            ++i2;
        }
        this.cutAction = new CutAction(){

            public void run() {
            }
        };
        this.copyAction = new CopyAction(){

            public void run() {
            }
        };
        this.pasteAction = new PasteAction(){

            public void run() {
            }
        };
        this.deleteAction = new DeleteAction(){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)ChartViewPart.this.getViewSite().getSelectionProvider().getSelection();
                if (!selection.isEmpty() && MessageDialog.openConfirm((Shell)ChartViewPart.this.getViewSite().getShell(), (String)ChartViewPart.this.getPartName(), (String)Messages.ChartViewPart_DeleteConfirmMessage)) {
                    ChartViewItem viewItem = (ChartViewItem)((Object)selection.getFirstElement());
                    ChartRowViewItem rowViewItem = (ChartRowViewItem)viewItem.getParent();
                    if (rowViewItem.getItemCount() == 1) {
                        rowViewItem.getParentView().removeRow(rowViewItem);
                    } else {
                        rowViewItem.removeChildItem(viewItem);
                    }
                }
            }
        };
        this.deleteChartAction = new Action(String.valueOf(Messages.ChartViewPart_DeleteAction) + " Chart"){

            public void run() {
                ChartViewPart.this.deleteChart();
            }
        };
        this.deleteChartAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteChartAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteChartAction.setEnabled(true);
        this.updateAction = new Action(Messages.ChartViewPart_UpdateAction){

            public void run() {
                TimeSpan timeSpan = TimeSpan.fromString((String)ChartViewPart.this.dialogSettings.get(ChartViewPart.K_PERIOD));
                int interval = 8;
                if (timeSpan != null && timeSpan.getUnits() == TimeSpan.Units.Days) {
                    interval = 0;
                }
                final DataImportJob job = new DataImportJob(ChartViewPart.this.security, 0, null, null, interval);
                job.setUser(true);
                job.schedule();
                job.addJobChange((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        ChartViewPart.this.updateAction.setEnabled(!job.isRequestSent());
                    }
                });
            }
        };
        this.updateAction.setId("update");
        this.updateAction.setImageDescriptor(ChartsUIActivator.imageDescriptorFromPlugin("icons/etool16/refresh.gif"));
        this.updateAction.setEnabled(true);
        this.chartsPallateAction = new Action(Messages.ChartViewPart_ChartsPalleteAction){

            public void run() {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    page.showView("org.eclipsetrader.ui.charts.palette");
                }
                catch (PartInitException e) {
                    CorePlugin.logException((Exception)((Object)e));
                }
            }
        };
        this.chartsPallateAction.setId("chartsPallete");
        this.chartsPallateAction.setImageDescriptor(ChartsUIActivator.imageDescriptorFromPlugin("icons/etool16/palette.png"));
        this.chartsPallateAction.setEnabled(true);
        this.resetChart = new Action(Messages.ChartViewPart_ResetChartsAction){

            public void run() {
                int i = 0;
                while (i < ChartViewPart.this.templateActions.length) {
                    if (ChartViewPart.this.templateActions[i].isChecked()) {
                        ChartViewPart.this.setChartTemplate(ChartViewPart.this.templateActions[i].getTemplate());
                        ChartViewPart.this.viewer.setZoomFactor(0);
                        ChartViewPart.this.zoomOutAction.setEnabled(false);
                        ChartViewPart.this.zoomResetAction.setEnabled(false);
                        break;
                    }
                    ++i;
                }
            }
        };
        this.resetChart.setId("resetChart");
        this.resetChart.setImageDescriptor(ChartsUIActivator.imageDescriptorFromPlugin("icons/etool16/reset.png"));
        this.resetChart.setToolTipText("Reset Chart Layout");
        this.resetChart.setEnabled(true);
        this.fitChart = new Action("Fit chart on one page", 2){

            public void run() {
                ChartViewPart.this.viewer.setFillAvailableSpace(this.isChecked());
                ChartViewPart.this.refreshChart();
            }
        };
        this.fitChart.setId("fitChart");
        this.fitChart.setImageDescriptor(ChartsUIActivator.imageDescriptorFromPlugin("icons/etool16/fit.png"));
        this.fitChart.setToolTipText("Fit chart on one page");
        this.propertiesAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)this.getViewSite().getShell()), this.getSite().getSelectionProvider()){

            public void run() {
                PreferenceDialog dialog = this.createDialog();
                if (dialog != null && dialog.open() == 0) {
                    IStructuredSelection selection = (IStructuredSelection)ChartViewPart.this.getSite().getSelectionProvider().getSelection();
                    try {
                        ChartViewItem viewItem = (ChartViewItem)((Object)selection.getFirstElement());
                        ((ChartRowViewItem)viewItem.getParent()).refresh();
                    }
                    catch (Exception exception) {}
                    ChartViewPart.this.refreshChart();
                    ChartViewPart.this.setDirty();
                }
            }
        };
        this.propertiesAction.setId(ActionFactory.PROPERTIES.getId());
        this.propertiesAction.setActionDefinitionId("org.eclipse.ui.file.properties");
        this.propertiesAction.setEnabled(false);
        this.currentPriceLineAction = new Action(Messages.ChartViewPart_ShowCurrentPriceAction, 2){

            public void run() {
                ChartViewPart.this.currentPriceLineFactory.setEnable(this.isChecked());
                ChartViewPart.this.dialogSettings.put(ChartViewPart.K_SHOW_CURRENT_PRICE, this.isChecked());
            }
        };
        this.currentBookAction = new Action(Messages.ChartViewPart_ShowBookAction, 2){

            public void run() {
                ChartViewPart.this.currentBookFactory.setEnable(this.isChecked());
                ChartViewPart.this.dialogSettings.put(ChartViewPart.K_SHOW_CURRENT_BOOK, this.isChecked());
            }
        };
    }

    public void createPartControl(Composite parent) {
        this.viewer = new BaseChartViewer(parent, 0);
        this.viewer.setHorizontalScaleVisible(true);
        this.viewer.setVerticalScaleVisible(true);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChartViewPart.this.handleSelectionChanged((IStructuredSelection)event.getSelection());
                ChartViewPart.this.handleActionsEnablement();
            }
        });
        this.viewer.getEditor().addListener(new IChartEditorListener(){

            @Override
            public void applyEditorValue() {
                ChartViewPart.this.refreshChart();
                ChartViewPart.this.setDirty();
            }

            @Override
            public void cancelEditor() {
            }
        });
        Transfer[] transferTypes = new Transfer[]{ChartObjectFactoryTransfer.getInstance()};
        DropTarget dropTarget = new DropTarget(this.viewer.getControl(), 3);
        dropTarget.setTransfer(transferTypes);
        this.dropListener = new ChartViewDropTarget(this);
        dropTarget.addDropListener((DropTargetListener)this.dropListener);
        this.viewer.setShowTooltips(this.preferenceStore.getBoolean("SHOW_TOOLTIPS"));
        this.viewer.setShowScaleTooltips(this.preferenceStore.getBoolean("SHOW_SCALE_TOOLTIPS"));
        this.viewer.setCrosshairMode(this.preferenceStore.getInt("CROSSHAIR_ACTIVATION"));
        this.viewer.setDecoratorSummaryTooltips(this.preferenceStore.getBoolean("CROSSHAIR_SUMMARY_TOOLTIP"));
        this.preferenceStore.addPropertyChangeListener(this.preferenceChangeListener);
        this.viewer.sashForm.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                ChartViewPart.this.saveWeights();
            }

            public void controlMoved(ControlEvent e) {
                ChartViewPart.this.saveWeights();
            }
        });
        if (this.memento != null && this.memento.getString(K_ZOOM_FACTOR) != null) {
            int factor = this.memento.getInteger(K_ZOOM_FACTOR);
            this.viewer.setZoomFactor(factor);
            this.zoomOutAction.setEnabled(factor != 0);
            this.zoomResetAction.setEnabled(factor != 0);
        }
        this.createContextMenu();
        this.currentPriceLineFactory = new CurrentPriceLineFactory(this.security);
        this.currentPriceLineFactory.setEnable(this.dialogSettings.getBoolean(K_SHOW_CURRENT_PRICE));
        this.currentPriceLineAction.setChecked(this.dialogSettings.getBoolean(K_SHOW_CURRENT_PRICE));
        this.currentBookFactory = new CurrentBookFactory(this.security);
        this.currentBookFactory.setEnable(this.dialogSettings.getBoolean(K_SHOW_CURRENT_BOOK));
        this.currentBookAction.setChecked(this.dialogSettings.getBoolean(K_SHOW_CURRENT_BOOK));
        this.view = new ChartView(this.template);
        ChartRowViewItem rowItem = (ChartRowViewItem)this.view.getItems()[0];
        ChartViewItem viewItem = new ChartViewItem(rowItem, this.currentPriceLineFactory);
        rowItem.addChildItem(0, viewItem);
        viewItem = new ChartViewItem(rowItem, this.currentBookFactory);
        rowItem.addChildItem(0, viewItem);
        this.view.addViewChangeListener(this.viewChangeListener);
        this.setSecurity(this.security);
    }

    public void setSecurity(Security security) {
        this.security = security;
        if (security != null && this.template != null) {
            this.dialogSettings.put(K_URI, security.getId());
            this.setPartName(NLS.bind((String)"{0} - {1}", (Object[])new Object[]{security.getId(), this.template.getName()}));
        }
        this.scheduleLoadJob(true, true);
        this.subscribe(security);
    }

    void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.add((IContributionItem)new Separator("top"));
                menuManager.add((IAction)ChartViewPart.this.cutAction);
                menuManager.add((IAction)ChartViewPart.this.copyAction);
                menuManager.add((IAction)ChartViewPart.this.pasteAction);
                menuManager.add((IContributionItem)new Separator());
                menuManager.add((IAction)ChartViewPart.this.deleteAction);
                menuManager.add((IContributionItem)new Separator("additions"));
                menuManager.add((IAction)ChartViewPart.this.propertiesAction);
            }
        });
        this.viewer.getControl().setMenu(menuMgr.createContextMenu(this.viewer.getControl()));
        this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
    }

    synchronized void scheduleLoadJob(final boolean update, final boolean fromDB) {
        PropertyChangeSupport propertyChangeSupport;
        if (this.security == null) {
            return;
        }
        final Display display = this.viewer.getControl().getDisplay();
        if (this.history != null && (propertyChangeSupport = (PropertyChangeSupport)this.history.getAdapter(PropertyChangeSupport.class)) != null) {
            propertyChangeSupport.removePropertyChangeListener(this.propertyChangeListener);
        }
        ChartLoadJob job = new ChartLoadJob(this.security, this.view);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                final ChartLoadJob job = (ChartLoadJob)event.getJob();
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).ChartViewPart.this.viewer.getControl().isDisposed()) {
                            return;
                        }
                        if ((this).ChartViewPart.this.memento == null) {
                            (this).ChartViewPart.this.memento = XMLMemento.createWriteRoot((String)"root");
                        }
                        ChartViewPart.this.saveState((this).ChartViewPart.this.memento);
                        ChartViewPart.this.view = job.getView();
                        TimeSpan resolutionTimeSpan = TimeSpan.fromString((String)ChartViewPart.this.dialogSettings.get(ChartViewPart.K_RESOLUTION));
                        if (resolutionTimeSpan == null) {
                            resolutionTimeSpan = TimeSpan.days((int)1);
                        }
                        (this).ChartViewPart.this.viewer.setResolutionTimeSpan(resolutionTimeSpan);
                        ChartViewPart.this.dropListener.setView(ChartViewPart.this.view);
                        TimeSpan timeSpan = TimeSpan.fromString((String)ChartViewPart.this.dialogSettings.get(ChartViewPart.K_PERIOD));
                        if (Resources.refDataComplete && fromDB && timeSpan != null && timeSpan.getUnits() == TimeSpan.Units.Days) {
                            ChartViewPart.this.updateAction.run();
                            return;
                        }
                        ChartViewPart.this.history = job.getHistory();
                        if (ChartViewPart.this.history != null && ChartViewPart.this.history.getOHLC() != null && ChartViewPart.this.history.getOHLC().length > 0) {
                            PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)ChartViewPart.this.history.getAdapter(PropertyChangeSupport.class);
                            if (propertyChangeSupport != null) {
                                propertyChangeSupport.addPropertyChangeListener(ChartViewPart.this.propertyChangeListener);
                            }
                            ChartViewPart.this.refreshChart();
                        } else {
                            String period;
                            String string = period = ChartViewPart.this.dialogSettings.get(ChartViewPart.K_PERIOD) == null ? "All" : ChartViewPart.this.dialogSettings.get(ChartViewPart.K_PERIOD);
                            if (update) {
                                boolean download = MessageDialog.openQuestion(null, (String)"Chart Data", (String)("No data available for the period (" + period + ").Would you like to update it from database?\n\nThis process may take approximately one minute to update it from database."));
                                if (download) {
                                    ChartViewPart.this.updateAction.run();
                                } else {
                                    ChartViewPart.this.refreshChart();
                                }
                            } else {
                                ChartViewPart.this.refreshChart();
                            }
                        }
                    }
                });
            }
        });
        job.setTimeSpan(TimeSpan.fromString((String)this.dialogSettings.get(K_PERIOD)));
        job.setResolutionTimeSpan(TimeSpan.fromString((String)this.dialogSettings.get(K_RESOLUTION)));
        job.setName(String.valueOf(Messages.ChartViewPart_LoadingText) + this.getPartName());
        job.setUser(true);
        job.schedule();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        PropertyChangeSupport propertyChangeSupport;
        if (this.currentPriceLineFactory != null) {
            this.currentPriceLineFactory.dispose();
        }
        if (this.currentBookFactory != null) {
            this.currentBookFactory.dispose();
        }
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        try {
            this.view.removeViewChangeListener(this.viewChangeListener);
        }
        catch (Exception exception) {}
        if (this.history != null && (propertyChangeSupport = (PropertyChangeSupport)this.history.getAdapter(PropertyChangeSupport.class)) != null) {
            propertyChangeSupport.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (ChartsUIActivator.getDefault() != null) {
            IPreferenceStore preferences = ChartsUIActivator.getDefault().getPreferenceStore();
            preferences.removePropertyChangeListener(this.preferenceChangeListener);
        }
        this.unsubscribe(this.security);
        super.dispose();
    }

    protected void handleSelectionChanged(IStructuredSelection selection) {
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof IChartObject)) {
            this.getViewSite().getSelectionProvider().setSelection((ISelection)StructuredSelection.EMPTY);
            return;
        }
        ChartViewItemFinder finder = new ChartViewItemFinder((IChartObject)selection.getFirstElement());
        this.view.accept(finder);
        if (finder.getViewItem() == null) {
            this.getViewSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)this.view));
        } else {
            this.getViewSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)finder.getViewItem()));
        }
    }

    protected void handleActionsEnablement() {
        IStructuredSelection selection = (IStructuredSelection)this.getViewSite().getSelectionProvider().getSelection();
        try {
            IViewItem viewItem = (IViewItem)selection.getFirstElement();
            this.propertiesAction.setEnabled(!selection.isEmpty());
            this.cutAction.setEnabled(!selection.isEmpty() && viewItem != null && viewItem.getAdapter(MainChartFactory.class) == null);
            this.copyAction.setEnabled(!selection.isEmpty() && viewItem != null && viewItem.getAdapter(MainChartFactory.class) == null);
            this.deleteAction.setEnabled(!selection.isEmpty() && viewItem != null && viewItem.getAdapter(MainChartFactory.class) == null);
        }
        catch (Exception exception) {}
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            String privateTemplate = this.marshal(this.view.getTemplate());
            this.dialogSettings.put(K_PRIVATE_TEMPLATE, privateTemplate);
            this.clearDirty();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteChart() {
        try {
            if (this.security != null) {
                this.security.deleteIntradayHistory();
                this.security.deleteHistory();
            }
            this.dialogSettings.put(K_PRIVATE_TEMPLATE, "basic-template.xml");
            this.clearDirty();
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            window.getActivePage().hideView((IViewPart)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSaveAs() {
    }

    protected void setDirty() {
        if (!this.dirty) {
            this.dirty = true;
            this.firePropertyChange(257);
        }
    }

    protected void clearDirty() {
        if (this.dirty) {
            this.dirty = false;
            this.firePropertyChange(257);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.dirty;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(BaseChartViewer.class)) {
            return this.viewer;
        }
        if (adapter.isAssignableFrom(ChartCanvas.class)) {
            return this.viewer.getSelectedChartCanvas();
        }
        if (adapter.isAssignableFrom(ChartView.class)) {
            return this.view;
        }
        if (adapter.isAssignableFrom(IChartTemplate.class)) {
            return this.template;
        }
        if (adapter.isAssignableFrom(ISecurity.class)) {
            return this.security;
        }
        if (adapter.isAssignableFrom(IDialogSettings.class)) {
            return this.dialogSettings;
        }
        return super.getAdapter(adapter);
    }

    private String marshal(IChartTemplate object) throws Exception {
        StringWriter string = new StringWriter();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ChartTemplate.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.marshal((Object)object, (Writer)string);
        return string.toString();
    }

    private ChartTemplate unmarshal(String string) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ChartTemplate.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return (ChartTemplate)unmarshaller.unmarshal((Reader)new StringReader(string));
    }

    private ChartTemplate unmarshal(InputStream stream) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ChartTemplate.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return (ChartTemplate)unmarshaller.unmarshal(stream);
    }

    public void setChartTemplate(String templateName) {
        try {
            this.dialogSettings.put(K_TEMPLATE_TYPE, templateName);
            IPath templatePath = new Path("data").append(this.dialogSettings.get(templateName));
            InputStream stream = FileLocator.openStream((Bundle)ChartsUIActivator.getDefault().getBundle(), (IPath)templatePath, (boolean)false);
            this.template = this.unmarshal(stream);
            this.view.setTemplate(this.template);
            if (this.security != null && this.template != null) {
                this.setPartName(NLS.bind((String)"{0} - {1}", (Object[])new Object[]{this.security.getId(), this.template.getName()}));
            }
            ChartRowViewItem rowItem = (ChartRowViewItem)this.view.getItems()[0];
            ChartViewItem viewItem = new ChartViewItem(rowItem, this.currentPriceLineFactory);
            rowItem.addChildItem(0, viewItem);
            viewItem = new ChartViewItem(rowItem, this.currentBookFactory);
            rowItem.addChildItem(0, viewItem);
            this.refreshChart();
            this.setDirty();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void refreshChart() {
        if (this.viewer != null && !this.viewer.isDisposed()) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ChartRowViewItem[] rowViewItem = (ChartRowViewItem[])ChartViewPart.this.view.getAdapter(ChartRowViewItem[].class);
                    if (rowViewItem != null) {
                        IChartObject[][] input = new IChartObject[rowViewItem.length][];
                        int i = 0;
                        while (i < input.length) {
                            input[i] = (IChartObject[])rowViewItem[i].getAdapter(IChartObject[].class);
                            ++i;
                        }
                        ChartViewPart.this.viewer.setInput(input);
                        if (ChartViewPart.this.memento != null && ChartViewPart.this.memento.getString(ChartViewPart.K_WEIGHTS) != null) {
                            String[] s = ChartViewPart.this.memento.getString(ChartViewPart.K_WEIGHTS).split(";");
                            int[] weights = ChartViewPart.this.viewer.getWeights();
                            int i2 = 0;
                            while (i2 < weights.length && i2 < s.length) {
                                weights[i2] = Integer.valueOf(s[i2]);
                                ++i2;
                            }
                            ChartViewPart.this.viewer.setWeights(weights);
                        }
                    }
                }
            });
        }
    }

    public void setPeriod(TimeSpan period, TimeSpan resolution) {
        this.dialogSettings.put(K_PERIOD, period != null ? period.toString() : null);
        this.dialogSettings.put(K_RESOLUTION, resolution != null ? resolution.toString() : null);
        this.periodAllAction.setChecked(period == null);
        int i = 0;
        while (i < this.periodAction.length) {
            if (resolution == null) {
                this.periodAction[i].setChecked(this.periodAction[i].getPeriod().equals((Object)period));
            } else {
                this.periodAction[i].setChecked(this.periodAction[i].getPeriod().equals((Object)period) && this.periodAction[i].getResolution().equals((Object)resolution));
            }
            ++i;
        }
        this.scheduleLoadJob(true, false);
    }

    public void itemAdded(Object o) {
        if (o instanceof pk.com.softech.tradingterminal.core.db.History) {
            this.updateAction.setEnabled(true);
            this.scheduleLoadJob(false, false);
        }
    }

    public void itemRemoved(Object o) {
    }

    @Override
    public void update(Observable o, Object obj) {
        if (o == this.security.getQuoteMonitor()) {
            this.viewer.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        TimeSpan timeSpan = TimeSpan.fromString((String)ChartViewPart.this.dialogSettings.get(ChartViewPart.K_PERIOD));
                        TimeSpan resolutionTimeSpan = TimeSpan.fromString((String)ChartViewPart.this.dialogSettings.get(ChartViewPart.K_RESOLUTION));
                        if (timeSpan != null && timeSpan.getUnits() == TimeSpan.Units.Days) {
                            if (ChartViewPart.this.history == null) {
                                if (timeSpan.getUnits() == TimeSpan.Units.Days) {
                                    ChartViewPart.this.history = (IHistory)new HistoryDay((ISecurity)ChartViewPart.this.security, resolutionTimeSpan);
                                } else {
                                    ChartViewPart.this.history = (IHistory)new History((ISecurity)ChartViewPart.this.security, new IOHLC[0], resolutionTimeSpan);
                                }
                            } else {
                                try {
                                    Quote bar = ChartViewPart.this.security.getQuote();
                                    OHLC newFeed = ChartViewPart.this.security.getMarket().equalsIgnoreCase("EXCH") ? new OHLC(bar.getDate(), ChartViewPart.this.security.getOpen(), ChartViewPart.this.security.getHigh(), ChartViewPart.this.security.getLow(), ChartViewPart.this.security.getCurrentIndex(), Long.valueOf(bar.getVolume())) : new OHLC(bar.getDate(), ChartViewPart.this.security.getOpen(), ChartViewPart.this.security.getHigh(), ChartViewPart.this.security.getLow(), Double.valueOf(bar.getLast()), Long.valueOf(bar.getVolume()));
                                    ChartViewPart.this.history.addOHLC((IOHLC)newFeed);
                                    IHistory newHistory = ChartViewPart.this.history.getSubset(ChartViewPart.this.history.getFirst().getDate(), bar.getDate(), resolutionTimeSpan);
                                    ChartViewPart.this.view.setRootDataSeries((IDataSeries)new OHLCDataSeries(ChartViewPart.this.security.getDescription(), newHistory.getOHLC(), resolutionTimeSpan));
                                    ChartViewPart.this.refreshChart();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void subscribe(Security sec) {
        if (sec != null) {
            this.unsubscribe(this.security);
            sec.getQuoteMonitor().addObserver((Observer)this);
            FeedMonitor.monitor((Security)sec);
        }
    }

    public void unsubscribe(Security sec) {
        if (sec != null) {
            sec.getQuoteMonitor().deleteObserver((Observer)this);
            FeedMonitor.cancelMonitor((Security)sec);
        }
    }
}

