/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipsetrader.ui.charts.ChartCanvas;
import org.eclipsetrader.ui.charts.ChartRowViewItem;
import org.eclipsetrader.ui.charts.ChartView;
import org.eclipsetrader.ui.charts.ChartViewItem;
import org.eclipsetrader.ui.charts.IChartEditorListener;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import org.eclipsetrader.ui.charts.IEditableChartObject;
import org.eclipsetrader.ui.internal.charts.ChartsUIActivator;
import org.eclipsetrader.ui.internal.charts.views.ChartViewPart;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.transfers.SecurityTransfer;

public class ChartViewDropTarget
extends DropTargetAdapter {
    Shell shell;
    ChartViewPart chartView;
    ChartView view;

    public ChartViewDropTarget(ChartViewPart view) {
        this.shell = view.viewer.getControl().getShell();
        this.chartView = view;
    }

    public void setView(ChartView view) {
        this.view = view;
    }

    public void drop(DropTargetEvent event) {
        if (SecurityTransfer.getInstance().isSupportedType(event.currentDataType)) {
            Security[] securities = (Security[])event.data;
            this.chartView.setSecurity(securities[0]);
        } else {
            ChartRowViewItem rowItem = null;
            ChartCanvas[] chartCanvas = this.chartView.viewer.getChildren();
            int i = 0;
            while (i < chartCanvas.length) {
                Rectangle bounds = chartCanvas[i].getCanvas().getBounds();
                if (bounds.contains(chartCanvas[i].getCanvas().toControl(event.x, event.y))) {
                    rowItem = (ChartRowViewItem)this.view.getItems()[i];
                    break;
                }
                ++i;
            }
            String[] factories = (String[])event.data;
            int i2 = 0;
            while (i2 < factories.length) {
                final IChartObjectFactory factory = ChartsUIActivator.getDefault().getChartObjectFactory(factories[i2]);
                if (factory != null) {
                    final IChartObject chartObject = factory.createObject(null);
                    if (chartObject instanceof IEditableChartObject) {
                        this.chartView.viewer.getEditor().addListener(new IChartEditorListener(){

                            @Override
                            public void applyEditorValue() {
                                ChartViewDropTarget.this.chartView.viewer.getEditor().removeListener(this);
                                IChartObject[] currentObject = ChartViewDropTarget.this.chartView.viewer.getSelectedChartCanvas().getChartObject();
                                int index = ChartViewDropTarget.this.chartView.viewer.getSelectedChartCanvasIndex();
                                if (index != -1) {
                                    IChartObject[] newObject = new IChartObject[currentObject.length + 1];
                                    System.arraycopy(currentObject, 0, newObject, 0, currentObject.length);
                                    newObject[currentObject.length] = chartObject;
                                    ChartViewDropTarget.this.chartView.viewer.getSelectedChartCanvas().setChartObject(newObject);
                                    ((ChartRowViewItem)ChartViewDropTarget.this.view.getItems()[index]).addFactory(factory);
                                    ChartViewDropTarget.this.chartView.viewer.setSelection((ISelection)new StructuredSelection((Object)chartObject));
                                }
                            }

                            @Override
                            public void cancelEditor() {
                                ChartViewDropTarget.this.chartView.viewer.getEditor().removeListener(this);
                            }
                        });
                        this.chartView.viewer.activateEditor((IEditableChartObject)chartObject);
                    } else {
                        boolean addToNewRow = false;
                        IConfigurationElement configurationElement = ChartsUIActivator.getDefault().getChartObjectConfiguration(factories[i2]);
                        if (!"false".equals(configurationElement.getAttribute("exclusive"))) {
                            addToNewRow = true;
                        }
                        PropertyPageManager pageManager = new PropertyPageManager();
                        if (addToNewRow) {
                            PropertyDialog dlg;
                            ChartRowViewItem newRowItem = new ChartRowViewItem(this.view, factory.getName());
                            ChartViewItem viewItem = new ChartViewItem(newRowItem, factory);
                            newRowItem.addChildItem(viewItem);
                            PropertyPageContributorManager.getManager().contribute(pageManager, (Object)viewItem);
                            Iterator pages = pageManager.getElements(0).iterator();
                            if (pages.hasNext() && (dlg = PropertyDialog.createDialogOn((Shell)this.shell, null, (Object)((Object)viewItem))).open() == 0) {
                                this.view.addRowAfter(rowItem, newRowItem);
                            }
                        } else {
                            PropertyDialog dlg;
                            ChartViewItem viewItem = new ChartViewItem(rowItem, factory);
                            PropertyPageContributorManager.getManager().contribute(pageManager, (Object)viewItem);
                            Iterator pages = pageManager.getElements(0).iterator();
                            if (pages.hasNext() && (dlg = PropertyDialog.createDialogOn((Shell)this.shell, null, (Object)((Object)viewItem))).open() == 0) {
                                rowItem.addChildItem(viewItem);
                            }
                        }
                    }
                }
                ++i2;
            }
        }
    }
}

