/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.views;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.OHLCDataSeries;
import org.eclipsetrader.core.feed.History;
import org.eclipsetrader.core.feed.HistoryDay;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.OHLC;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.ui.charts.ChartView;
import org.eclipsetrader.ui.internal.charts.ChartsUIActivator;
import org.eclipsetrader.ui.internal.charts.views.Messages;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Bar;
import pk.com.softech.tradingterminal.core.db.IntradayHistory;
import pk.com.softech.tradingterminal.core.db.Security;

public class ChartLoadJob
extends Job {
    Security security;
    ChartView view;
    TimeSpan timeSpan;
    TimeSpan resolutionTimeSpan;
    IHistory history;

    public ChartLoadJob(Security security, ChartView view) {
        super("");
        this.security = security;
        this.view = view;
    }

    public void setTimeSpan(TimeSpan timeSpan) {
        this.timeSpan = timeSpan;
    }

    public void setResolutionTimeSpan(TimeSpan resolutionTimeSpan) {
        this.resolutionTimeSpan = resolutionTimeSpan;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(this.getName(), -1);
        try {
            try {
                this.buildHistory();
                try {
                    IOHLC[] values = this.history.getOHLC();
                    this.view.setRootDataSeries((IDataSeries)new OHLCDataSeries(this.security.getDescription(), values, this.resolutionTimeSpan));
                    this.view.setRootDataSeries((IDataSeries)new OHLCDataSeries(this.security.getDescription(), values, this.resolutionTimeSpan));
                }
                catch (Exception exception) {
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipsetrader.ui.charts", 0, String.valueOf(Messages.ChartLoadJob_ExceptionMessage) + this.security.getDescription(), (Throwable)e);
                ChartsUIActivator.log((IStatus)status);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    void buildHistory() {
        this.history = this.getHistoryFor(this.security, this.timeSpan);
        if (this.timeSpan != null) {
            Calendar c = Calendar.getInstance();
            c.set(11, 23);
            c.set(12, 59);
            c.set(13, 59);
            c.set(14, 999);
            Date lastDate = c.getTime();
            if (this.timeSpan.getUnits() == TimeSpan.Units.Days) {
                int index = this.history.getOHLC().length - this.timeSpan.getLength();
                if (index > 0) {
                    Calendar c2 = Calendar.getInstance();
                    c2.set(11, 0);
                    c2.set(12, 0);
                    c2.set(13, 0);
                    c2.set(14, 0);
                    Date firstDate = c2.getTime();
                    this.history = this.history.getSubset(firstDate, lastDate, this.resolutionTimeSpan);
                }
            } else {
                c = Calendar.getInstance();
                if (this.history.getLast() != null) {
                    c.setTime(this.history.getLast().getDate());
                } else {
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    c.set(14, 0);
                }
                switch (this.timeSpan.getUnits()) {
                    case Months: {
                        c.add(2, -this.timeSpan.getLength());
                        if (this.resolutionTimeSpan != null) {
                            this.history = this.history.getSubset(c.getTime(), lastDate, this.resolutionTimeSpan);
                            break;
                        }
                        this.history = this.history.getSubset(c.getTime(), lastDate);
                        break;
                    }
                    case Years: {
                        c.add(1, -this.timeSpan.getLength());
                        this.history = this.history.getSubset(c.getTime(), lastDate);
                    }
                }
            }
        }
    }

    IHistory getHistoryFor(Security security, TimeSpan timeSpan) {
        History history;
        pk.com.softech.tradingterminal.core.db.History his = null;
        if (timeSpan != null && timeSpan.getUnits() == TimeSpan.Units.Days) {
            his = (pk.com.softech.tradingterminal.core.db.History)CorePlugin.getRepository().load(IntradayHistory.class, security.getId());
            history = new HistoryDay((ISecurity)security, this.resolutionTimeSpan);
        } else {
            his = (pk.com.softech.tradingterminal.core.db.History)CorePlugin.getRepository().load(pk.com.softech.tradingterminal.core.db.History.class, security.getId());
            history = new History((ISecurity)security, (IOHLC[])new OHLC[0], this.resolutionTimeSpan);
        }
        List list = his.getList();
        OHLC[] bars = new OHLC[list.size()];
        int i = 0;
        while (i < bars.length) {
            OHLC data;
            Bar bar = (Bar)list.get(i);
            bars[i] = data = new OHLC(bar.getDate(), Double.valueOf(bar.getOpen()), Double.valueOf(bar.getHigh()), Double.valueOf(bar.getLow()), Double.valueOf(bar.getClose()), Long.valueOf(bar.getVolume()));
            ++i;
        }
        history.setOHLC((IOHLC[])bars);
        return history;
    }

    public ChartView getView() {
        return this.view;
    }

    public IHistory getHistory() {
        return this.history;
    }
}

