/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.tools;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.ui.internal.charts.tools.LineToolFactory;
import org.eclipsetrader.ui.internal.charts.tools.Messages;
import pk.com.softech.tradingterminal.core.CorePlugin;

public class LinePropertiesPage
extends PropertyPage {
    private Text text;
    private ColorSelector color;
    private Text value1;
    private CDateTime date1;
    private Button extend1;
    private Text value2;
    private CDateTime date2;
    private Button extend2;
    private NumberFormat numberFormat = CorePlugin.getPriceFormatter();
    private FocusAdapter numberFocusListener = new FocusAdapter(){

        public void focusLost(FocusEvent event) {
            Text text = (Text)event.widget;
            try {
                Number number = LinePropertiesPage.this.numberFormat.parse(text.getText());
                text.setText(LinePropertiesPage.this.numberFormat.format(number));
            }
            catch (ParseException parseException) {
                text.setData("valid", (Object)Boolean.FALSE);
            }
            LinePropertiesPage.this.setValid(!Boolean.FALSE.equals(LinePropertiesPage.this.value1.getData("valid")) && !Boolean.FALSE.equals(LinePropertiesPage.this.value2.getData("valid")));
        }
    };

    public LinePropertiesPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setTitle(Messages.LinePropertiesPage_Title);
        Label label = new Label(content, 0);
        label.setText(Messages.LinePropertiesPage_LabelLabel);
        label.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(75), -1));
        this.text = new Text(content, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label = new Label(content, 0);
        label.setText(Messages.LinePropertiesPage_ColorLabel);
        this.color = new ColorSelector(content);
        this.color.setColorValue(new RGB(0, 0, 255));
        this.color.getButton().setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        ((GridData)label.getLayoutData()).heightHint = this.convertVerticalDLUsToPixels(5);
        label = new Label(content, 0);
        label.setText(Messages.LinePropertiesPage_FirstPointLabel);
        this.date1 = new CDateTime(content, 0x200003);
        this.date1.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(90), -1));
        this.value1 = new Text(content, 2048);
        this.value1.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(65), -1));
        this.value1.addFocusListener((FocusListener)this.numberFocusListener);
        label = new Label(content, 0);
        this.extend1 = new Button(content, 32);
        this.extend1.setText(Messages.LinePropertiesPage_ExtendLabel);
        this.extend1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label = new Label(content, 0);
        label.setText(Messages.LinePropertiesPage_SecondPointLabel);
        this.date2 = new CDateTime(content, 0x200003);
        this.date2.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(90), -1));
        this.value2 = new Text(content, 2048);
        this.value2.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(65), -1));
        this.value2.addFocusListener((FocusListener)this.numberFocusListener);
        label = new Label(content, 0);
        this.extend2 = new Button(content, 32);
        this.extend2.setText(Messages.LinePropertiesPage_ExtendLabel);
        this.extend2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        LineToolFactory object = (LineToolFactory)this.getElement().getAdapter(LineToolFactory.class);
        this.text.setText(object.getName());
        this.value1.setText(this.numberFormat.format(object.getValue1().getValue()));
        this.date1.setSelection(object.getValue1().getDate());
        this.extend1.setSelection(object.isExtend1());
        this.value2.setText(this.numberFormat.format(object.getValue2().getValue()));
        this.date2.setSelection(object.getValue2().getDate());
        this.extend2.setSelection(object.isExtend2());
        this.color.setColorValue(object.getColor() != null ? object.getColor() : new RGB(0, 0, 0));
        super.performDefaults();
    }

    public boolean performOk() {
        LineToolFactory object = (LineToolFactory)this.getElement().getAdapter(LineToolFactory.class);
        object.setName(this.text.getText());
        try {
            object.setValue1(new LineToolFactory.Value(this.date1.getSelection(), this.numberFormat.parse(this.value1.getText())));
            object.setValue2(new LineToolFactory.Value(this.date2.getSelection(), this.numberFormat.parse(this.value2.getText())));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        object.setExtend1(this.extend1.getSelection());
        object.setExtend2(this.extend2.getSelection());
        object.setColor(this.color.getColorValue());
        return super.performOk();
    }
}

