/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.ui.internal.charts.ChartsUIActivator;
import org.eclipsetrader.ui.internal.charts.Messages;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Repository;
import pk.com.softech.tradingterminal.core.db.Security;

public class ImportDataPage
extends WizardPage {
    private static final String K_SELECTION = "SELECTION";
    private static final String K_SECURITIES = "SECURITIES";
    private static final String K_MODE = "MODE";
    private static final String K_FROM_DATE = "FROM_DATE";
    private static final String K_AGGREGATION = "AGGREGATION";
    private Combo type;
    private CDateTime from;
    private CDateTime to;
    private CheckboxTableViewer aggregation;
    private Combo combo;
    private CheckboxTableViewer members;

    public ImportDataPage() {
        super("data", Messages.ImportDataPage_Title, null);
        this.setDescription(Messages.ImportDataPage_Description);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.setControl((Control)content);
        this.initializeDialogUnits((Control)parent);
        Label label = new Label(content, 0);
        label.setText(Messages.ImportDataPage_TypeLabel);
        this.type = new Combo(content, 12);
        this.type.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.type.add(Messages.ImportDataPage_FullText);
        this.type.select(0);
        this.type.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int typeIndex = ImportDataPage.this.type.getSelectionIndex();
                ImportDataPage.this.from.setEnabled(typeIndex == 0 || typeIndex == 2);
                ImportDataPage.this.to.setEnabled(typeIndex == 0);
                if (typeIndex != 0) {
                    ImportDataPage.this.to.setSelection(Calendar.getInstance().getTime());
                }
                ImportDataPage.this.setPageComplete(ImportDataPage.this.isPageComplete());
            }
        });
        label = new Label(content, 0);
        label.setText(Messages.ImportDataPage_PeriodLabel);
        Composite group = new Composite(content, 0);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        group.setLayout((Layout)gridLayout);
        this.from = new CDateTime(group, 34603011);
        label = new Label(group, 0);
        label.setText(Messages.ImportDataPage_ToLabel);
        this.to = new CDateTime(group, 34603011);
        Calendar today = Calendar.getInstance();
        this.to.setSelection(today.getTime());
        today.add(1, -10);
        this.from.setSelection(today.getTime());
        label = new Label(content, 0);
        label.setText(Messages.ImportDataPage_AggregationLabel);
        label.setLayoutData((Object)new GridData(128, 131072, false, false));
        ((GridData)label.getLayoutData()).verticalIndent = this.convertVerticalDLUsToPixels(2);
        this.aggregation = CheckboxTableViewer.newCheckList((Composite)content, (int)2048);
        this.aggregation.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)this.aggregation.getControl().getLayoutData()).heightHint = this.aggregation.getTable().getItemHeight() * 3;
        this.aggregation.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.aggregation.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                TimeSpan timeSpan = (TimeSpan)element;
                return NLS.bind((String)"{0} {1}", (Object[])new Object[]{String.valueOf(timeSpan.getLength()), timeSpan.getUnits() == TimeSpan.Units.Minutes ? Messages.ImportDataPage_MinutesText : Messages.ImportDataPage_DaysText});
            }
        });
        this.aggregation.setInput((Object)new TimeSpan[]{TimeSpan.days((int)1), TimeSpan.minutes((int)1), TimeSpan.minutes((int)2), TimeSpan.minutes((int)3), TimeSpan.minutes((int)5), TimeSpan.minutes((int)10), TimeSpan.minutes((int)15), TimeSpan.minutes((int)30), TimeSpan.minutes((int)60)});
        this.aggregation.setChecked(((Object[])this.aggregation.getInput())[0], true);
        label = new Label(content, 0);
        label.setText(Messages.ImportDataPage_ImportLabel);
        this.combo = new Combo(content, 12);
        this.combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.combo.add(Messages.ImportDataPage_AllSecuritiesText);
        this.combo.add(Messages.ImportDataPage_SelectedSecuritiesText);
        this.combo.select(0);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDataPage.this.members.getControl().setEnabled(ImportDataPage.this.combo.getSelectionIndex() != 0);
                ImportDataPage.this.setPageComplete(ImportDataPage.this.isPageComplete());
            }
        });
        this.members = CheckboxTableViewer.newCheckList((Composite)content, (int)2820);
        this.members.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        ((GridData)this.members.getControl().getLayoutData()).heightHint = this.members.getTable().getItemHeight() * 10 + this.members.getTable().getBorderWidth() * 2;
        ((GridData)this.members.getControl().getLayoutData()).verticalIndent = 5;
        this.members.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Security)element).getId();
            }
        });
        this.members.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.members.setSorter(new ViewerSorter());
        this.members.setInput((Object)CorePlugin.getRepository().allSecurities());
        this.restoreState();
        int typeIndex = this.type.getSelectionIndex();
        this.from.setEnabled(typeIndex == 0 || typeIndex == 2);
        this.to.setEnabled(typeIndex == 0);
        this.members.getControl().setEnabled(this.combo.getSelectionIndex() != 0);
        this.aggregation.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ImportDataPage.this.setPageComplete(ImportDataPage.this.isPageComplete());
            }
        });
        this.members.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ImportDataPage.this.setPageComplete(ImportDataPage.this.isPageComplete());
            }
        });
    }

    protected void restoreState() {
        IDialogSettings dialogSettings = ChartsUIActivator.getDefault().getDialogSettings().getSection(((Object)((Object)this)).getClass().getName());
        if (dialogSettings != null) {
            String[] selection;
            String[] s;
            if (dialogSettings.get(K_MODE) != null) {
                this.type.select(dialogSettings.getInt(K_MODE));
            }
            if (dialogSettings.get(K_FROM_DATE) != null) {
                try {
                    this.from.setSelection(new SimpleDateFormat("yyyyMMdd").parse(dialogSettings.get(K_FROM_DATE)));
                }
                catch (Exception exception) {}
            }
            if ((s = dialogSettings.getArray(K_AGGREGATION)) != null) {
                this.aggregation.setAllChecked(false);
                Object[] ts = new TimeSpan[s.length];
                int i = 0;
                while (i < ts.length) {
                    ts[i] = TimeSpan.fromString((String)s[i]);
                    ++i;
                }
                this.aggregation.setCheckedElements(ts);
            }
            if (dialogSettings.get(K_SECURITIES) != null) {
                this.combo.select(dialogSettings.getInt(K_SECURITIES));
            }
            if ((selection = dialogSettings.getArray(K_SELECTION)) != null) {
                Repository repository = CorePlugin.getRepository();
                int i = 0;
                while (i < selection.length) {
                    try {
                        Security security = (Security)repository.load(Security.class, selection[i]);
                        if (security != null) {
                            this.members.setChecked((Object)security, true);
                        }
                    }
                    catch (Exception exception) {}
                    ++i;
                }
            }
        }
    }

    public void saveState() {
        IDialogSettings dialogSettings = ChartsUIActivator.getDefault().getDialogSettings().getSection(((Object)((Object)this)).getClass().getName());
        if (dialogSettings == null) {
            dialogSettings = ChartsUIActivator.getDefault().getDialogSettings().addNewSection(((Object)((Object)this)).getClass().getName());
        }
        dialogSettings.put(K_MODE, this.type.getSelectionIndex());
        dialogSettings.put(K_FROM_DATE, new SimpleDateFormat("yyyyMMdd").format(this.from.getSelection()));
        TimeSpan[] ts = this.getAggregation();
        String[] s = new String[ts.length];
        int i = 0;
        while (i < s.length) {
            s[i] = ts[i].toString();
            ++i;
        }
        dialogSettings.put(K_AGGREGATION, s);
        dialogSettings.put(K_SECURITIES, this.combo.getSelectionIndex());
        Object[] o = this.members.getCheckedElements();
        String[] selection = new String[o.length];
        int i2 = 0;
        while (i2 < o.length) {
            Security storeObject = (Security)o[i2];
            selection[i2] = storeObject.getId();
            ++i2;
        }
        dialogSettings.put(K_SELECTION, selection);
    }

    public boolean isPageComplete() {
        if (this.aggregation.getCheckedElements().length == 0) {
            return false;
        }
        if (this.from.getEnabled() && this.from.getSelection() == null) {
            return false;
        }
        if (this.to.getEnabled() && this.to.getSelection() == null) {
            return false;
        }
        if (this.combo.getSelectionIndex() == 0) {
            return true;
        }
        return this.members.getCheckedElements().length != 0;
    }

    public Security[] getCheckedSecurities() {
        Object[] o = this.combo.getSelectionIndex() == 0 ? (Object[])this.members.getInput() : this.members.getCheckedElements();
        Security[] securities = new Security[o.length];
        System.arraycopy(o, 0, securities, 0, securities.length);
        return securities;
    }

    public TimeSpan[] getAggregation() {
        Object[] ar = this.aggregation.getCheckedElements();
        TimeSpan[] r = new TimeSpan[ar.length];
        System.arraycopy(ar, 0, r, 0, r.length);
        return r;
    }

    public Date getFromDate() {
        return this.from.getSelection();
    }

    public Date getToDate() {
        return this.to.getSelection();
    }

    public int getImportType() {
        switch (this.type.getSelectionIndex()) {
            case 0: {
                return 0;
            }
        }
        return 0;
    }
}

