/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipsetrader.ui.internal.charts.ChartsUIActivator;
import pk.com.softech.tradingterminal.core.CorePlugin;

public class DefaultsPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Button useStartDate;
    CDateTime startDate;
    Button useYears;
    Spinner years;
    SimpleDateFormat prefsDateFormat = new SimpleDateFormat("yyyyMMdd");

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(CorePlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(2);
        content.setLayout((Layout)gridLayout);
        Group group = new Group(content, 0);
        group.setText("Initial backfill");
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        gridLayout = new GridLayout(3, false);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(2);
        group.setLayout((Layout)gridLayout);
        this.useStartDate = new Button((Composite)group, 16);
        this.useStartDate.setText("Start Date");
        this.useStartDate.setEnabled(false);
        this.startDate = new CDateTime((Composite)group, 0x200001);
        this.startDate.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        ((GridData)this.startDate.getLayoutData()).widthHint = this.convertHorizontalDLUsToPixels(62);
        this.useYears = new Button((Composite)group, 16);
        this.useYears.setText("Last");
        this.useYears.setEnabled(true);
        this.years = new Spinner((Composite)group, 2048);
        this.years.setValues(1, 1, 10, 0, 1, 10);
        Label label = new Label((Composite)group, 0);
        label.setText("year(s)");
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        IPreferenceStore preferences = this.getPreferenceStore();
        int v = preferences.getInt("INITIAL_BACKFILL_METHOD");
        this.useStartDate.setSelection(v == 0);
        this.useYears.setSelection(v == 1);
        String s = preferences.getString("INITIAL_BACKFILL_START_DATE");
        if (!s.equals("")) {
            try {
                Date date = this.prefsDateFormat.parse(s);
                this.startDate.setSelection(date);
            }
            catch (ParseException e) {
                Status status = new Status(4, "org.eclipsetrader.ui.charts", 0, "Error parsing start date " + s, (Throwable)e);
                ChartsUIActivator.log((IStatus)status);
            }
        }
        this.years.setSelection(preferences.getInt("HISTORICAL_PRICE_RANGE"));
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore preferences = this.getPreferenceStore();
        if (this.useStartDate.getSelection()) {
            preferences.setValue("INITIAL_BACKFILL_METHOD", 0);
        } else if (this.useYears.getSelection()) {
            preferences.setValue("INITIAL_BACKFILL_METHOD", 1);
        }
        if (this.startDate.getSelection() != null) {
            preferences.setValue("INITIAL_BACKFILL_START_DATE", this.prefsDateFormat.format(this.startDate.getSelection()));
        } else {
            preferences.setValue("INITIAL_BACKFILL_START_DATE", "");
        }
        preferences.setValue("HISTORICAL_PRICE_RANGE", this.years.getSelection());
        return super.performOk();
    }
}

