/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.ui.internal.charts.Messages;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.IHistoryFeed;
import pk.com.softech.tradingterminal.core.db.Security;

public class DataImportJob
extends Job {
    public static final int FULL = 0;
    private Security[] securities;
    private int mode;
    private TimeSpan[] timeSpan;
    private Date fromDate;
    private Date toDate;
    private int interval;
    private boolean requestSent;
    private IJobChangeListener mainJob;
    private List<IStatus> results = new ArrayList<IStatus>();
    IPreferenceStore preferences;
    Job subJob;

    public DataImportJob(Security security, int mode, Date fromDate, Date toDate, int interval) {
        super(Messages.DataImportJob_Name);
        this.securities = new Security[]{security};
        this.mode = mode;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.interval = interval;
    }

    public DataImportJob(Security[] securities, int mode, Date fromDate, Date toDate, TimeSpan[] timeSpan) {
        super(Messages.DataImportJob_Name);
        this.securities = securities;
        this.mode = mode;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.timeSpan = timeSpan;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.subJob = new Job("Update chart data"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Update chart data", DataImportJob.this.securities.length);
                int i = 0;
                while (i < DataImportJob.this.securities.length) {
                    IHistoryFeed feed;
                    final Security security = DataImportJob.this.securities[i];
                    monitor.subTask("Updating " + security.getDescription().replaceAll("&", "&&"));
                    String id = "";
                    if (security.getHistoryFeed() != null) {
                        id = security.getHistoryFeed().getId();
                    }
                    if ((feed = CorePlugin.createHistoryFeedPlugin((String)id)) != null) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                DataImportJob.this.requestSent = feed.updateHistory(security, DataImportJob.this.interval);
                            }
                        });
                    }
                    monitor.worked(1);
                    ++i;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        this.subJob.setUser(true);
        this.subJob.schedule();
        this.subJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                DataImportJob.this.mainJob.done(new IJobChangeEvent(){

                    public IStatus getResult() {
                        return Status.OK_STATUS;
                    }

                    public Job getJob() {
                        return null;
                    }

                    public long getDelay() {
                        return 0L;
                    }
                });
            }
        });
        return Status.CANCEL_STATUS;
    }

    public void addJobChange(IJobChangeListener listener) {
        this.mainJob = listener;
    }

    public boolean isRequestSent() {
        return this.requestSent;
    }
}

