/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import org.eclipsetrader.ui.internal.charts.Messages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import pk.com.softech.tradingterminal.core.CorePlugin;

public class ChartsUIActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipsetrader.ui.charts";
    public static final String INDICATORS_EXTENSION_ID = "org.eclipsetrader.ui.indicators";
    public static final String PREFS_SHOW_SCALE_TOOLTIPS = "SHOW_SCALE_TOOLTIPS";
    public static final String PREFS_CROSSHAIR_ACTIVATION = "CROSSHAIR_ACTIVATION";
    public static final String PREFS_CROSSHAIR_SUMMARY_TOOLTIP = "CROSSHAIR_SUMMARY_TOOLTIP";
    public static final String PREFS_SHOW_TOOLTIPS = "SHOW_TOOLTIPS";
    public static final String PREFS_INITIAL_BACKFILL_METHOD = "INITIAL_BACKFILL_METHOD";
    public static final String PREFS_INITIAL_BACKFILL_START_DATE = "INITIAL_BACKFILL_START_DATE";
    public static final String PREFS_MARKET_DEPTH_LEVELS = "MARKET_DEPTH_LEVELS";
    public static final String PREFS_SHOW_PRICE_VOLUME = "SHOW_PRICE_VOLUME";
    public static final int DEFAULT_MARKET_DEPTH = 5;
    private static ChartsUIActivator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.copyFileToStateLocation("basic-template.xml");
        this.copyFileToStateLocation("advanced-template.xml");
        this.copyFileToStateLocation("research-template.xml");
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ChartsUIActivator getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public IChartObjectFactory getChartObjectFactory(String targetID) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(INDICATORS_EXTENSION_ID);
        if (extensionPoint == null) {
            return null;
        }
        IConfigurationElement targetElement = null;
        IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
        int j = 0;
        while (j < configElements.length) {
            String strID = configElements[j].getAttribute("id");
            if (targetID.equals(strID)) {
                targetElement = configElements[j];
                break;
            }
            ++j;
        }
        if (targetElement == null) {
            return null;
        }
        try {
            return (IChartObjectFactory)targetElement.createExecutableExtension("class");
        }
        catch (Exception e) {
            Status status = new Status(2, PLUGIN_ID, 0, String.valueOf(Messages.ChartsUIActivator_IndicatorErrorMessage) + targetID, (Throwable)e);
            this.getLog().log((IStatus)status);
            return null;
        }
    }

    public IConfigurationElement getChartObjectConfiguration(String targetID) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(INDICATORS_EXTENSION_ID);
        if (extensionPoint == null) {
            return null;
        }
        IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
        int j = 0;
        while (j < configElements.length) {
            String strID = configElements[j].getAttribute("id");
            if (targetID.equals(strID)) {
                return configElements[j];
            }
            ++j;
        }
        return null;
    }

    public IDialogSettings getDialogSettingsForView(URI uri) {
        String uriString = uri.toString();
        IDialogSettings rootSettings = this.getDialogSettings().getSection("Views");
        if (rootSettings == null) {
            rootSettings = this.getDialogSettings().addNewSection("Views");
        }
        IDialogSettings[] sections = rootSettings.getSections();
        int i = 0;
        while (i < sections.length) {
            if (uriString.equals(sections[i].getName()) && sections[i].get("Template-Type") != null) {
                sections[i].put("Basic-Template", "basic-template.xml");
                sections[i].put("Advanced-Template", "advanced-template.xml");
                sections[i].put("Research-Template", "research-template.xml");
                return sections[i];
            }
            ++i;
        }
        IDialogSettings dialogSettings = rootSettings.addNewSection(uriString);
        dialogSettings.put("uri", uriString);
        dialogSettings.put("Template-Type", "Basic-Template");
        dialogSettings.put("Basic-Template", "basic-template.xml");
        dialogSettings.put("Advanced-Template", "advanced-template.xml");
        dialogSettings.put("Research-Template", "research-template.xml");
        dialogSettings.put("show-current-price", "true");
        dialogSettings.put("show-current-book", "true");
        return dialogSettings;
    }

    private void copyFileToStateLocation(String file) {
        File f = ChartsUIActivator.getDefault().getStateLocation().append(file).toFile();
        if (!f.exists()) {
            try {
                byte[] buffer = new byte[10240];
                FileOutputStream os = new FileOutputStream(f);
                InputStream is = FileLocator.openStream((Bundle)this.getBundle(), (IPath)new Path("data/" + file), (boolean)false);
                int readed = 0;
                do {
                    readed = is.read(buffer);
                    ((OutputStream)os).write(buffer, 0, readed);
                } while (readed == buffer.length);
                ((OutputStream)os).close();
                is.close();
            }
            catch (Exception e) {
                CorePlugin.logException((Exception)e);
            }
        }
    }

    public static ImageDescriptor imageDescriptorFromPlugin(String imageFilePath) {
        return ChartsUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)imageFilePath);
    }
}

