/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.text.NumberFormat;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipsetrader.core.feed.IOHLC;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;

public class SummaryOHLCItem {
    Label label;
    Label changeLabel;
    NumberFormat priceFormat = CorePlugin.getPriceFormatter();
    NumberFormat percentFormat = CorePlugin.getPercentageFormatter();
    Color foreground;
    Color positiveForeground;
    Color negativeForeground;

    public SummaryOHLCItem(Composite parent, int style) {
        this.changeLabel = new Label(parent, 0);
        this.label = new Label(parent, 0);
        this.foreground = parent.getDisplay().getSystemColor(9);
        this.positiveForeground = parent.getDisplay().getSystemColor(6);
        this.negativeForeground = parent.getDisplay().getSystemColor(3);
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getPositiveForeground() {
        return this.positiveForeground;
    }

    public void setPositiveForeground(Color positiveColor) {
        this.positiveForeground = positiveColor;
    }

    public Color getNegativeForeground() {
        return this.negativeForeground;
    }

    public void setNegativeForeground(Color negativeColor) {
        this.negativeForeground = negativeColor;
    }

    public void setOHLC(IOHLC currentOHLC, IOHLC previousOHLC) {
        if (currentOHLC != null) {
            this.label.setText(NLS.bind((String)"O={0} H={1} L={2} C={3}", (Object[])new Object[]{this.priceFormat.format(currentOHLC.getOpen()), this.priceFormat.format(currentOHLC.getHigh()), this.priceFormat.format(currentOHLC.getLow()), this.priceFormat.format(currentOHLC.getClose())}));
            if (previousOHLC != null) {
                double change = currentOHLC.getClose() - currentOHLC.getOpen();
                double changePerc = Resources.getChangePercentage((double)currentOHLC.getClose(), (double)change);
                this.changeLabel.setText(NLS.bind((String)"{0} ({1})", (Object[])new Object[]{String.valueOf(change > 0.0 ? "+" : "") + this.priceFormat.format(change), String.valueOf(changePerc > 0.0 ? "+" : "") + this.percentFormat.format(changePerc)}));
                if (changePerc > 0.0) {
                    this.changeLabel.setForeground(this.positiveForeground);
                } else if (changePerc < 0.0) {
                    this.changeLabel.setForeground(this.negativeForeground);
                } else {
                    this.changeLabel.setForeground(null);
                }
            }
        } else {
            this.label.setText("");
            this.changeLabel.setText("");
            this.changeLabel.setForeground(null);
        }
        this.label.setForeground(this.foreground);
        this.label.getParent().layout();
    }
}

