/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.ui.charts.ChartObjectFocusEvent;
import org.eclipsetrader.ui.charts.DataBounds;
import org.eclipsetrader.ui.charts.Graphics;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectVisitor;
import org.eclipsetrader.ui.charts.IGraphics;
import org.eclipsetrader.ui.charts.ISummaryBarDecorator;
import org.eclipsetrader.ui.charts.PixelTools;
import org.eclipsetrader.ui.charts.SummaryNumberItem;
import pk.com.softech.tradingterminal.core.CorePlugin;

public class LineChart
implements IChartObject,
ISummaryBarDecorator,
IAdaptable {
    private IDataSeries dataSeries;
    private LineStyle style;
    private RGB color;
    private int width = 5;
    private IAdaptable[] values;
    private Point[] pointArray;
    private boolean valid;
    private boolean hasFocus;
    private SummaryNumberItem numberItem;
    private NumberFormat priceFormat = CorePlugin.getPriceFormatter();

    public LineChart(IDataSeries dataSeries, LineStyle style, RGB color) {
        this.dataSeries = dataSeries;
        this.style = style;
        this.color = color;
    }

    public RGB getColor() {
        return this.color;
    }

    public void setColor(RGB color) {
        this.color = color;
    }

    @Override
    public void setDataBounds(DataBounds dataBounds) {
        ArrayList<IAdaptable> l = new ArrayList<IAdaptable>(2048);
        IAdaptable[] iAdaptableArray = this.dataSeries.getValues();
        int n = iAdaptableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable value = iAdaptableArray[n2];
            Date date = (Date)value.getAdapter(Date.class);
            if (!(dataBounds.first != null && date.before(dataBounds.first) || dataBounds.last != null && date.after(dataBounds.last))) {
                l.add(value);
            }
            ++n2;
        }
        this.values = l.toArray(new IAdaptable[l.size()]);
        this.width = dataBounds.horizontalSpacing;
        this.valid = false;
    }

    @Override
    public void handleFocusGained(ChartObjectFocusEvent event) {
        this.hasFocus = true;
    }

    @Override
    public void handleFocusLost(ChartObjectFocusEvent event) {
        this.hasFocus = false;
    }

    protected boolean hasFocus() {
        return this.hasFocus;
    }

    @Override
    public void invalidate() {
        this.valid = false;
    }

    @Override
    public void paint(IGraphics graphics) {
        if (!(this.valid && this.pointArray != null || this.values == null || this.style == LineStyle.Invisible)) {
            this.pointArray = new Point[this.values.length];
            int i = 0;
            while (i < this.values.length) {
                Date date = (Date)this.values[i].getAdapter(Date.class);
                Number value = (Number)this.values[i].getAdapter(Number.class);
                this.pointArray[i] = graphics.mapToPoint(date, value);
                ++i;
            }
            this.valid = true;
        }
        if (this.pointArray != null && this.style != LineStyle.Invisible) {
            switch (this.style) {
                case Dash: {
                    graphics.setLineStyle(2);
                    break;
                }
                case Dot: {
                    graphics.setLineStyle(3);
                    break;
                }
                default: {
                    graphics.setLineStyle(1);
                }
            }
            graphics.pushState();
            graphics.setForegroundColor(this.color);
            graphics.setLineWidth(this.hasFocus() ? 2 : 1);
            graphics.drawPolyline(this.pointArray);
            graphics.popState();
        }
    }

    @Override
    public void paintScale(Graphics graphics) {
    }

    @Override
    public boolean containsPoint(int x, int y) {
        if (this.pointArray != null) {
            if (y == -1) {
                return true;
            }
            return PixelTools.isPointOnLine(x, y, this.pointArray);
        }
        return false;
    }

    @Override
    public IDataSeries getDataSeries() {
        return this.dataSeries;
    }

    @Override
    public String getToolTip() {
        if (this.dataSeries.getLast() != null) {
            return String.valueOf(this.dataSeries.getName()) + ": " + this.priceFormat.format(this.dataSeries.getLast().getAdapter(Number.class));
        }
        return this.dataSeries.getName();
    }

    @Override
    public String getToolTip(int x, int y) {
        block6: {
            if (this.pointArray == null) break block6;
            if (y == -1) {
                int i = 0;
                while (i < this.pointArray.length) {
                    if (x >= this.pointArray[i].x - this.width / 2 && x <= this.pointArray[i].x + this.width / 2) {
                        return String.valueOf(this.dataSeries.getName()) + ": " + this.priceFormat.format(this.values[i].getAdapter(Number.class));
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i < this.pointArray.length) {
                    if (PixelTools.isPointOnLine(x, y, this.pointArray[i - 1].x, this.pointArray[i - 1].y, this.pointArray[i].x, this.pointArray[i].y)) {
                        return String.valueOf(this.dataSeries.getName()) + " " + this.priceFormat.format(this.values[i - 1].getAdapter(Number.class));
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    @Override
    public void accept(IChartObjectVisitor visitor) {
        visitor.visit(this);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ISummaryBarDecorator.class)) {
            return this;
        }
        return null;
    }

    @Override
    public void createDecorator(Composite parent) {
        IAdaptable[] values = this.dataSeries.getValues();
        Number value = (Number)(values.length > 0 ? values[values.length - 1].getAdapter(Number.class) : null);
        this.numberItem = new SummaryNumberItem(parent, 0);
        this.numberItem.setValue(String.valueOf(this.dataSeries.getName()) + ": ", value);
        if (this.color != null) {
            this.numberItem.setForeground(this.color);
        }
    }

    @Override
    public void updateDecorator(int x, int y) {
        if (this.pointArray != null) {
            Number value = null;
            if (y == -1) {
                int i = 0;
                while (i < this.pointArray.length) {
                    if (x >= this.pointArray[i].x - this.width / 2 && x <= this.pointArray[i].x + this.width / 2) {
                        value = (Number)this.values[i].getAdapter(Number.class);
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i < this.pointArray.length) {
                    if (PixelTools.isPointOnLine(x, y, this.pointArray[i - 1].x, this.pointArray[i - 1].y, this.pointArray[i].x, this.pointArray[i].y)) {
                        value = (Number)this.values[i - 1].getAdapter(Number.class);
                    }
                    ++i;
                }
            }
            if (value != null) {
                this.numberItem.setValue(String.valueOf(this.dataSeries.getName()) + ": ", value);
            }
        }
    }

    public static enum LineStyle {
        Solid,
        Dot,
        Dash,
        Invisible;

    }
}

