/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.util.ArrayList;
import java.util.List;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.ui.charts.ChartObjectFocusEvent;
import org.eclipsetrader.ui.charts.DataBounds;
import org.eclipsetrader.ui.charts.Graphics;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectVisitor;
import org.eclipsetrader.ui.charts.IGraphics;

public class GroupChartObject
implements IChartObject {
    private List<IChartObject> objects = new ArrayList<IChartObject>();

    public void add(IChartObject object) {
        this.objects.add(object);
    }

    @Override
    public boolean containsPoint(int x, int y) {
        for (IChartObject o : this.objects) {
            if (!o.containsPoint(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IDataSeries getDataSeries() {
        return null;
    }

    @Override
    public String getToolTip() {
        for (IChartObject o : this.objects) {
            if (o.getToolTip() == null) continue;
            return o.getToolTip();
        }
        return null;
    }

    @Override
    public String getToolTip(int x, int y) {
        for (IChartObject o : this.objects) {
            if (o.getToolTip(x, y) == null) continue;
            return o.getToolTip(x, y);
        }
        return null;
    }

    @Override
    public void paint(IGraphics graphics) {
        for (IChartObject o : this.objects) {
            o.paint(graphics);
        }
    }

    @Override
    public void paintScale(Graphics graphics) {
        for (IChartObject o : this.objects) {
            o.paintScale(graphics);
        }
    }

    @Override
    public void invalidate() {
        for (IChartObject o : this.objects) {
            o.invalidate();
        }
    }

    @Override
    public void setDataBounds(DataBounds bounds) {
        for (IChartObject o : this.objects) {
            o.setDataBounds(bounds);
        }
    }

    @Override
    public void handleFocusGained(ChartObjectFocusEvent event) {
        for (IChartObject o : this.objects) {
            o.handleFocusGained(event);
        }
    }

    @Override
    public void handleFocusLost(ChartObjectFocusEvent event) {
        for (IChartObject o : this.objects) {
            o.handleFocusLost(event);
        }
    }

    @Override
    public void accept(IChartObjectVisitor visitor) {
        if (visitor.visit(this)) {
            for (IChartObject o : this.objects) {
                o.accept(visitor);
            }
        }
    }
}

