/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class DecoratorToolTip
extends ToolTip {
    public int OFFSET_X = 12;
    public int OFFSET_Y = 12;
    private Control parent;
    private CLabel label;
    private String text;

    public DecoratorToolTip(Control control) {
        super(control, 2, true);
        this.parent = control;
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        this.label = new CLabel(parent, 32);
        this.label.setBackground(parent.getDisplay().getSystemColor(29));
        this.label.setForeground(parent.getDisplay().getSystemColor(28));
        if (this.text != null) {
            this.label.setText(this.text);
        }
        return this.label;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setText(text);
            this.label.getParent().pack();
        }
    }

    protected boolean shouldCreateToolTip(Event event) {
        return this.label == null || this.label.isDisposed();
    }

    public Point getLocation(Point tipSize, Event event) {
        Rectangle bounds = this.parent.getBounds();
        Point p = new Point(event.x + this.OFFSET_X, event.y + this.OFFSET_Y);
        if (p.x + tipSize.x > bounds.width) {
            p.x = event.x - tipSize.x - this.OFFSET_X;
            if (p.x < 0) {
                p.x = event.x + this.OFFSET_X;
            }
        }
        if (p.y + tipSize.y > bounds.height) {
            p.y = event.y - tipSize.y - this.OFFSET_Y;
            if (p.y < 0) {
                p.y = event.y + this.OFFSET_Y;
            }
        }
        return this.parent.toDisplay(p);
    }

    public void show(Point location) {
        location = this.parent.toControl(location);
        if (this.label != null && !this.label.isDisposed()) {
            Shell tip = (Shell)this.label.getParent();
            Event event = new Event();
            event.x = location.x;
            event.y = location.y;
            event.widget = this.parent;
            tip.setLocation(this.getLocation(tip.getSize(), event));
        } else {
            super.show(location);
        }
    }
}

