/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.ui.charts.DateValuesAxis;
import org.eclipsetrader.ui.charts.DoubleValuesAxis;
import org.eclipsetrader.ui.charts.Graphics;
import org.eclipsetrader.ui.charts.Messages;
import org.eclipsetrader.ui.charts.Util;
import org.eclipsetrader.ui.internal.charts.ChartsUIActivator;
import pk.com.softech.tradingterminal.core.CorePlugin;

public class DateScaleCanvas {
    private Canvas horizontalScaleCanvas;
    private Image horizontalScaleImage;
    private Label label;
    private TimeSpan resolutionTimeSpan;
    private SimpleDateFormat monthYearFormatter = new SimpleDateFormat("MMM, yyyy");
    private SimpleDateFormat monthFormatter = new SimpleDateFormat("MMM");
    private SimpleDateFormat dayFormatter = new SimpleDateFormat("MMM, d");
    private DateFormat dateFormat = CorePlugin.getDateFormat();
    private DateFormat dateTimeFormat = CorePlugin.getDateTimeFormat();
    private DateFormat hourFormat = new SimpleDateFormat("HH:00");
    Point location;
    DateValuesAxis datesAxis;
    Date[] visibleDates;

    public DateScaleCanvas(Composite parent) {
        GC gc = new GC((Drawable)parent);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        this.horizontalScaleCanvas = new Canvas(parent, 0x200C0000);
        this.horizontalScaleCanvas.setBackground(Display.getCurrent().getSystemColor(25));
        this.horizontalScaleCanvas.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)this.horizontalScaleCanvas.getLayoutData()).heightHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)14);
        this.horizontalScaleCanvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (DateScaleCanvas.this.horizontalScaleImage != null) {
                    DateScaleCanvas.this.horizontalScaleImage.dispose();
                    DateScaleCanvas.this.horizontalScaleImage = null;
                }
                DateScaleCanvas.this.redraw();
            }
        });
        this.horizontalScaleCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (DateScaleCanvas.this.horizontalScaleImage != null) {
                    DateScaleCanvas.this.horizontalScaleImage.dispose();
                    DateScaleCanvas.this.horizontalScaleImage = null;
                }
            }
        });
        this.horizontalScaleCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                DateScaleCanvas.this.onPaint(e);
            }
        });
        this.label = new Label((Composite)this.horizontalScaleCanvas, 0);
        this.label.setBackground(this.horizontalScaleCanvas.getDisplay().getSystemColor(29));
        this.label.setBounds(-200, 0, 0, 0);
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    public void setDatesAxis(DateValuesAxis datesAxis) {
        this.datesAxis = datesAxis;
    }

    public Control getControl() {
        return this.horizontalScaleCanvas;
    }

    public Canvas getCanvas() {
        return this.horizontalScaleCanvas;
    }

    public void setVisibleDates(Date[] visibleDates) {
        this.visibleDates = visibleDates;
    }

    public void redraw() {
        this.horizontalScaleCanvas.setData("needs_redraw", (Object)Boolean.TRUE);
        this.horizontalScaleCanvas.redraw();
    }

    private void onPaint(PaintEvent event) {
        block32: {
            Rectangle clientArea = this.horizontalScaleCanvas.getClientArea();
            boolean needsRedraw = Boolean.TRUE.equals(this.horizontalScaleCanvas.getData("needs_redraw"));
            if (!(this.horizontalScaleImage == null || this.horizontalScaleImage.isDisposed() || this.horizontalScaleImage.getBounds().width == clientArea.width && this.horizontalScaleImage.getBounds().height == clientArea.height)) {
                this.horizontalScaleImage.dispose();
            }
            if (this.horizontalScaleImage == null || this.horizontalScaleImage.isDisposed()) {
                this.horizontalScaleImage = new Image((Device)this.horizontalScaleCanvas.getDisplay(), clientArea.width, clientArea.height);
                needsRedraw = true;
            }
            if (needsRedraw) {
                Graphics graphics = new Graphics((Drawable)this.horizontalScaleImage, this.location, this.datesAxis, new DoubleValuesAxis());
                try {
                    try {
                        graphics.fillRectangle(clientArea);
                        Calendar oldDate = null;
                        Calendar currentDate = Calendar.getInstance();
                        int tickCount = 0;
                        int monthRatio = 1;
                        int ratio1 = 0;
                        int ratio2 = 0;
                        if (this.visibleDates != null && this.visibleDates.length > 0) {
                            ratio1 = this.visibleDates.length / 150;
                            ratio2 = Math.max(4 - this.horizontalScaleImage.getBounds().width / this.visibleDates.length, 0);
                            monthRatio = Math.max(ratio1 + ratio2, 1);
                            if (monthRatio > 6) {
                                monthRatio = 12;
                            } else if (monthRatio >= 4) {
                                monthRatio = 6;
                            }
                        }
                        int i = 0;
                        while (i < this.visibleDates.length) {
                            ++tickCount;
                            Date date = this.visibleDates[i];
                            boolean tick = false;
                            boolean highlight = false;
                            String text = "";
                            currentDate.setTime(date);
                            if (oldDate != null) {
                                if (this.resolutionTimeSpan == null || this.resolutionTimeSpan.getUnits() == TimeSpan.Units.Days) {
                                    if (this.datesAxis.fillAvailableSpace) {
                                        if (this.visibleDates.length < 730) {
                                            int monthNo = oldDate.get(2) + 1;
                                            if (currentDate.get(1) != oldDate.get(1)) {
                                                tick = true;
                                                highlight = true;
                                                text = this.monthYearFormatter.format(currentDate.getTime());
                                            } else if (currentDate.get(2) != oldDate.get(2) && monthRatio != 0 && monthNo % monthRatio == 0) {
                                                tick = true;
                                                highlight = true;
                                                text = this.monthFormatter.format(currentDate.getTime());
                                            }
                                        } else if (currentDate.get(1) != oldDate.get(1)) {
                                            tick = true;
                                            highlight = true;
                                            text = this.monthYearFormatter.format(currentDate.getTime());
                                        }
                                    } else if (currentDate.get(1) != oldDate.get(1)) {
                                        tick = true;
                                        highlight = true;
                                        text = this.monthYearFormatter.format(currentDate.getTime());
                                    } else if (currentDate.get(2) != oldDate.get(2)) {
                                        tick = true;
                                        highlight = false;
                                        text = this.monthFormatter.format(currentDate.getTime());
                                    }
                                } else if (currentDate.get(5) != oldDate.get(5)) {
                                    tick = true;
                                    highlight = false;
                                    text = this.dayFormatter.format(currentDate.getTime());
                                } else if (currentDate.get(11) != oldDate.get(11) && tickCount > 10) {
                                    tickCount = 0;
                                    tick = true;
                                    highlight = false;
                                    text = this.hourFormat.format(currentDate.getTime());
                                }
                                oldDate.setTime(date);
                            } else {
                                oldDate = Calendar.getInstance();
                                oldDate.setTime(date);
                            }
                            int x = graphics.mapToHorizontalAxis(date);
                            graphics.setForegroundColor(highlight ? new RGB(255, 0, 0) : new RGB(0, 0, 0));
                            graphics.drawLine(x, 0, x, tick ? 6 : 3);
                            if (tick) {
                                graphics.drawString(text, x - 1, 7);
                            }
                            ++i;
                        }
                    }
                    catch (Error error) {
                        Status status = new Status(4, "org.eclipsetrader.ui.charts", Messages.DateScaleCanvas_HorizontalScaleRenderingError);
                        ChartsUIActivator.log((IStatus)status);
                        this.horizontalScaleCanvas.setData("needs_redraw", (Object)Boolean.FALSE);
                        graphics.dispose();
                        break block32;
                    }
                }
                catch (Throwable throwable) {
                    this.horizontalScaleCanvas.setData("needs_redraw", (Object)Boolean.FALSE);
                    graphics.dispose();
                    throw throwable;
                }
                this.horizontalScaleCanvas.setData("needs_redraw", (Object)Boolean.FALSE);
                graphics.dispose();
            }
        }
        Util.paintImage(event, this.horizontalScaleImage);
    }

    public void hideToolTip() {
        this.label.setLocation(-200, 0);
    }

    public void showToolTip(int x, int y, Date value) {
        if (value != null) {
            if (this.resolutionTimeSpan == null || this.resolutionTimeSpan.getUnits() == TimeSpan.Units.Days) {
                this.label.setText(this.dateFormat.format(value));
            } else {
                this.label.setText(this.dateTimeFormat.format(value));
            }
            this.label.pack();
            this.label.setLocation(x - this.label.getSize().x / 2, 0);
        }
    }

    public TimeSpan getResolutionTimeSpan() {
        return this.resolutionTimeSpan;
    }

    public void setResolutionTimeSpan(TimeSpan resolutionTimeSpan) {
        this.resolutionTimeSpan = resolutionTimeSpan;
    }
}

