/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipsetrader.ui.charts.ChartCanvas;
import org.eclipsetrader.ui.charts.DecoratorToolTip;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectVisitor;

public class CrosshairDecorator
implements MouseListener,
MouseMoveListener,
MouseTrackListener,
DisposeListener,
PaintListener {
    public static final int MODE_OFF = 0;
    public static final int MODE_MOUSE_DOWN = 1;
    public static final int MODE_MOUSE_HOVER = 2;
    private boolean active = true;
    private int mode = 0;
    private boolean showSummaryTooltip;
    private boolean mouseDown;
    private boolean skipPaint;
    private Point location;
    private ChartCanvas focusCanvas;
    private List<ChartCanvas> decoratedCanvas = new ArrayList<ChartCanvas>();
    private DecoratorToolTip tooltip;
    private StringBuilder summary = new StringBuilder();
    private IChartObjectVisitor summaryLabelVisitor = new IChartObjectVisitor(){

        @Override
        public boolean visit(IChartObject object) {
            String s = object.getToolTip(((CrosshairDecorator)CrosshairDecorator.this).location.x, -1);
            if (s != null) {
                if (CrosshairDecorator.this.summary.length() != 0) {
                    CrosshairDecorator.this.summary.append("\r\n");
                }
                CrosshairDecorator.this.summary.append(s);
            }
            return true;
        }
    };

    public void decorateCanvas(ChartCanvas canvas) {
        canvas.getCanvas().addMouseListener((MouseListener)this);
        canvas.getCanvas().addMouseMoveListener((MouseMoveListener)this);
        canvas.getCanvas().addMouseTrackListener((MouseTrackListener)this);
        canvas.getCanvas().addDisposeListener((DisposeListener)this);
        canvas.getCanvas().addPaintListener((PaintListener)this);
        this.decoratedCanvas.add(canvas);
    }

    public void createSummaryLabel(Composite parent) {
        this.tooltip = new DecoratorToolTip((Control)parent);
        this.tooltip.setRespectDisplayBounds(true);
        this.tooltip.setRespectMonitorBounds(true);
    }

    public void dispose() {
        for (ChartCanvas canvas : this.decoratedCanvas) {
            canvas.getCanvas().removeMouseListener((MouseListener)this);
            canvas.getCanvas().removeMouseMoveListener((MouseMoveListener)this);
            canvas.getCanvas().removeMouseTrackListener((MouseTrackListener)this);
            canvas.getCanvas().removeDisposeListener((DisposeListener)this);
            canvas.getCanvas().removePaintListener((PaintListener)this);
        }
        this.decoratedCanvas.clear();
    }

    public void activate() {
        if (!this.active) {
            this.active = true;
        }
    }

    public void deactivate() {
        if (this.active) {
            this.active = false;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isVisible() {
        return this.location != null;
    }

    public void widgetDisposed(DisposeEvent e) {
        for (ChartCanvas canvas : this.decoratedCanvas) {
            if (canvas.getCanvas() != e.widget) continue;
            this.decoratedCanvas.remove(canvas);
            break;
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (e.button != 1) {
            return;
        }
        if (this.mode == 1 && !this.mouseDown && this.active) {
            this.location = new Point(e.x, e.y);
            this.focusCanvas = (ChartCanvas)e.widget.getData();
            this.drawLines(this.location);
            this.updateLabel(this.location);
            this.mouseDown = true;
        }
    }

    public void mouseUp(MouseEvent e) {
        if (e.button != 1) {
            return;
        }
        if (this.mode == 1 && this.mouseDown) {
            this.skipPaint = true;
            this.restoreBackground(this.location);
            this.skipPaint = false;
            this.location = null;
            this.mouseDown = false;
            if (this.tooltip != null) {
                this.tooltip.hide();
            }
        }
    }

    public void mouseEnter(MouseEvent e) {
        if (this.mode == 2 || this.mouseDown) {
            this.focusCanvas = (ChartCanvas)e.widget.getData();
            this.location = new Point(e.x, e.y);
            this.drawLines(this.location);
            this.updateLabel(this.location);
        }
    }

    public void mouseExit(MouseEvent e) {
        if (this.location != null) {
            this.skipPaint = true;
            this.restoreBackground(this.location);
            this.skipPaint = false;
            this.location = null;
            if (this.tooltip != null) {
                this.tooltip.hide();
            }
        }
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseMove(MouseEvent e) {
        if (this.mode == 2 || this.mouseDown) {
            this.skipPaint = true;
            this.restoreBackground(this.location);
            this.skipPaint = false;
            this.focusCanvas = (ChartCanvas)e.widget.getData();
            this.location = new Point(e.x, e.y);
            this.drawLines(this.location);
            this.updateLabel(this.location);
        }
    }

    public void paintControl(PaintEvent e) {
        if (!this.skipPaint && this.active) {
            this.drawLines(this.location);
        }
    }

    private void drawLines(Point location) {
        if (this.focusCanvas == null || location == null) {
            return;
        }
        Rectangle bounds = this.focusCanvas.getCanvas().getBounds();
        GC gc = new GC((Drawable)this.focusCanvas.getCanvas());
        gc.drawLine(location.x, 0, location.x, bounds.height);
        gc.drawLine(0, location.y, bounds.width, location.y);
        gc.dispose();
        for (ChartCanvas canvas : this.decoratedCanvas) {
            if (canvas.getCanvas() == this.focusCanvas.getCanvas()) continue;
            bounds = canvas.getCanvas().getBounds();
            gc = new GC((Drawable)canvas.getCanvas());
            gc.drawLine(location.x, 0, location.x, bounds.height);
            gc.dispose();
        }
    }

    private void restoreBackground(Point location) {
        if (this.focusCanvas == null || location == null) {
            return;
        }
        Rectangle bounds = this.focusCanvas.getCanvas().getBounds();
        this.focusCanvas.getCanvas().redraw(location.x, 0, 1, bounds.height, false);
        this.focusCanvas.getCanvas().update();
        this.focusCanvas.getCanvas().redraw(0, location.y, bounds.width, 1, false);
        this.focusCanvas.getCanvas().update();
        for (ChartCanvas canvas : this.decoratedCanvas) {
            if (canvas.getCanvas() == this.focusCanvas.getCanvas()) continue;
            bounds = canvas.getCanvas().getBounds();
            canvas.getCanvas().redraw(location.x, 0, 1, bounds.height, false);
            canvas.getCanvas().update();
        }
    }

    private void updateLabel(Point location) {
        if (this.tooltip != null && location != null) {
            this.summary = new StringBuilder();
            for (ChartCanvas canvas : this.decoratedCanvas) {
                canvas.accept(this.summaryLabelVisitor);
            }
            this.tooltip.setText(this.summary.toString());
            if (this.showSummaryTooltip) {
                if (!"".equals(this.tooltip.getText())) {
                    Point p = new Point(location.x, location.y);
                    p = this.focusCanvas.getCanvas().toDisplay(p);
                    this.tooltip.show(p);
                } else {
                    this.tooltip.hide();
                }
            }
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public boolean isShowSummaryTooltip() {
        return this.showSummaryTooltip;
    }

    public void setShowSummaryTooltip(boolean showSummaryTooltip) {
        this.showSummaryTooltip = showSummaryTooltip;
        if (!showSummaryTooltip && this.tooltip != null) {
            this.tooltip.hide();
        }
    }
}

