/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.IDataSeriesVisitor;
import org.eclipsetrader.ui.charts.AdaptableWrapper;
import org.eclipsetrader.ui.charts.ChartItem;
import org.eclipsetrader.ui.charts.IAxis;
import org.eclipsetrader.ui.charts.IChartContentProvider;
import org.eclipsetrader.ui.charts.IChartRenderer;
import org.eclipsetrader.ui.charts.IScaleRenderer;
import org.eclipsetrader.ui.charts.Messages;
import org.eclipsetrader.ui.charts.RenderTarget;
import org.eclipsetrader.ui.internal.charts.ChartsUIActivator;

public class ChartViewer {
    private static final String K_NEEDS_REDRAW = "needs_redraw";
    private Composite composite;
    private SashForm sashForm;
    private ChartItem[] items = new ChartItem[0];
    private Canvas horizontalScaleCanvas;
    private Label verticalScaleLabel;
    private IAxis horizontalAxis;
    private IAxis verticalAxis;
    private IChartContentProvider contentProvider;
    private IChartRenderer renderer;
    private boolean verticalScaleVisible;
    private boolean horizontalScaleVisible;
    private Image horizontalScaleImage;
    private boolean needsRedraw;
    private Object input;

    public ChartViewer(Composite parent, int style) {
        this.composite = new Composite(parent, 768);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 3;
        gridLayout.horizontalSpacing = 3;
        this.composite.setLayout((Layout)gridLayout);
        this.sashForm = new SashForm(this.composite, 512);
        this.sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.horizontalScaleCanvas = new Canvas(this.composite, 0x20000000);
        this.horizontalScaleCanvas.setBackground(Display.getCurrent().getSystemColor(25));
        this.horizontalScaleCanvas.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)this.horizontalScaleCanvas.getLayoutData()).heightHint = 26;
        ((GridData)this.horizontalScaleCanvas.getLayoutData()).exclude = true;
        this.horizontalScaleCanvas.setVisible(false);
        this.horizontalScaleCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ChartViewer.this.onPaintHorizontalScale(e);
            }
        });
        this.horizontalScaleCanvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (ChartViewer.this.horizontalScaleImage != null) {
                    ChartViewer.this.horizontalScaleImage.dispose();
                    ChartViewer.this.horizontalScaleImage = null;
                }
            }
        });
        this.verticalScaleLabel = new Label(this.composite, 0);
        this.verticalScaleLabel.setLayoutData((Object)new GridData(86, -1));
        ((GridData)this.verticalScaleLabel.getLayoutData()).exclude = true;
        this.verticalScaleLabel.setVisible(false);
        Label label = new Label((Composite)this.sashForm, 0);
        label.setBackground(Display.getCurrent().getSystemColor(25));
        this.composite.getHorizontalBar().setVisible(false);
        this.composite.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartViewer.this.needsRedraw = true;
                int i = 0;
                while (i < ChartViewer.this.items.length) {
                    ChartViewer.this.items[i].getCanvas().setData(ChartViewer.K_NEEDS_REDRAW, (Object)Boolean.TRUE);
                    if (ChartViewer.this.items[i].getVerticalScaleCanvas() != null) {
                        ChartViewer.this.items[i].getVerticalScaleCanvas().setData(ChartViewer.K_NEEDS_REDRAW, (Object)Boolean.TRUE);
                    }
                    ChartViewer.this.items[i].redraw();
                    ++i;
                }
                if (ChartViewer.this.horizontalScaleCanvas != null) {
                    ChartViewer.this.horizontalScaleCanvas.setData(ChartViewer.K_NEEDS_REDRAW, (Object)Boolean.TRUE);
                    ChartViewer.this.horizontalScaleCanvas.redraw();
                }
            }
        });
        this.composite.getVerticalBar().setVisible(false);
        this.composite.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartViewer.this.sashForm.redraw(0, 0, 0, 0, true);
            }
        });
        this.sashForm.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ChartViewer.this.contentProvider != null) {
                    ChartViewer.this.contentProvider.dispose();
                }
                if (ChartViewer.this.renderer != null) {
                    ChartViewer.this.renderer.dispose();
                }
            }
        });
    }

    public void dispose() {
        this.composite.dispose();
    }

    public IAxis getHorizontalAxis() {
        return this.horizontalAxis;
    }

    public void setHorizontalAxis(IAxis horizontalAxis) {
        this.horizontalAxis = horizontalAxis;
    }

    public boolean isHorizontalScaleVisible() {
        return this.horizontalScaleVisible;
    }

    public void setHorizontalScaleVisible(boolean visible) {
        this.horizontalScaleVisible = visible;
    }

    public boolean isVerticalScaleVisible() {
        return this.verticalScaleVisible;
    }

    public void setVerticalScaleVisible(boolean verticalScaleVisible) {
        this.verticalScaleVisible = verticalScaleVisible;
    }

    public IAxis getVerticalAxis() {
        return this.verticalAxis;
    }

    public void setVerticalAxis(IAxis verticalAxis) {
        this.verticalAxis = verticalAxis;
    }

    public IChartContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(IChartContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public IChartRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(IChartRenderer renderer) {
        this.renderer = renderer;
    }

    public Object getInput() {
        return this.input;
    }

    public void setInput(Object input) {
        Assert.isTrue((this.getContentProvider() != null ? 1 : 0) != 0, (String)"ChartTemplate must have a content provider when input is set.");
        Object oldInput = this.getInput();
        this.contentProvider.inputChanged(this, oldInput, input);
        this.input = input;
        this.refresh();
    }

    public void refresh() {
        this.horizontalAxis.clear();
        this.verticalAxis.clear();
        Object[] elements = this.getInput() != null ? this.contentProvider.getElements(this.getInput()) : new Object[]{};
        ChartItem[] newItems = new ChartItem[elements.length];
        if (this.items != null) {
            Control[] c;
            int length = Math.min(this.items.length, newItems.length);
            System.arraycopy(this.items, 0, newItems, 0, length);
            int i = length;
            while (i < this.items.length) {
                this.items[i].dispose();
                ++i;
            }
            if (this.items.length == 0 && (c = this.sashForm.getChildren()).length != 0) {
                c[0].dispose();
            }
        }
        this.items = newItems;
        int i = 0;
        while (i < elements.length) {
            if (this.items[i] == null || this.items[i].isDisposed()) {
                this.items[i] = new ChartItem((Composite)this.sashForm, 0);
                this.items[i].setVerticalScaleVisible(this.verticalScaleVisible);
                this.items[i].getCanvas().addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        ChartViewer.this.onPaintItem(e);
                    }
                });
                this.items[i].getCanvas().addControlListener((ControlListener)new ControlAdapter(){

                    public void controlResized(ControlEvent e) {
                        e.widget.setData(ChartViewer.K_NEEDS_REDRAW, (Object)Boolean.TRUE);
                    }
                });
                this.items[i].getVerticalScaleCanvas().addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        ChartViewer.this.onPaintItemVerticalScale(e);
                    }
                });
                this.items[i].getVerticalScaleCanvas().addControlListener((ControlListener)new ControlAdapter(){

                    public void controlResized(ControlEvent e) {
                        e.widget.setData(ChartViewer.K_NEEDS_REDRAW, (Object)Boolean.TRUE);
                    }
                });
                if (i == 0) {
                    this.items[i].getCanvas().addControlListener((ControlListener)new ControlAdapter(){

                        public void controlResized(ControlEvent e) {
                            ChartViewer.this.updateScrollbars();
                        }
                    });
                }
            }
            this.items[i].setData(elements[i]);
            this.items[i].getCanvas().setData(K_NEEDS_REDRAW, (Object)Boolean.TRUE);
            if (this.items[i].getVerticalScaleCanvas() != null) {
                this.items[i].getVerticalScaleCanvas().setData(K_NEEDS_REDRAW, (Object)Boolean.TRUE);
            }
            this.items[i].redraw();
            IDataSeries dataSeries = null;
            if (elements[i] instanceof IDataSeries) {
                dataSeries = (IDataSeries)elements[i];
            } else if (elements[i] instanceof IAdaptable) {
                dataSeries = (IDataSeries)((IAdaptable)elements[i]).getAdapter(IDataSeries.class);
            }
            if (dataSeries != null) {
                dataSeries.accept(new IDataSeriesVisitor(){

                    public boolean visit(IDataSeries data) {
                        ChartViewer.this.horizontalAxis.addValues(data.getValues());
                        return true;
                    }
                });
                this.verticalAxis.addValues(new IAdaptable[]{dataSeries.getHighest(), dataSeries.getLowest()});
            }
            ++i;
        }
        if (this.items.length == 0) {
            Label label = new Label((Composite)this.sashForm, 0);
            label.setBackground(Display.getCurrent().getSystemColor(25));
        }
        this.needsRedraw = true;
        if (this.horizontalScaleCanvas != null) {
            this.horizontalScaleCanvas.setData(K_NEEDS_REDRAW, (Object)Boolean.TRUE);
            this.horizontalScaleCanvas.redraw();
        }
        this.updateScrollbars();
        int[] weights = new int[this.items.length];
        if (weights.length != 0) {
            weights[0] = 100;
            int i2 = 1;
            while (i2 < weights.length) {
                weights[i2] = 25;
                ++i2;
            }
            this.sashForm.setWeights(weights);
        }
        this.sashForm.layout();
        if (this.items.length != 0 && this.verticalScaleVisible && !this.verticalScaleLabel.getVisible()) {
            ((GridData)this.verticalScaleLabel.getLayoutData()).exclude = false;
            this.verticalScaleLabel.setVisible(true);
        }
        if ((this.items.length == 0 || !this.verticalScaleVisible) && this.verticalScaleLabel.getVisible()) {
            ((GridData)this.verticalScaleLabel.getLayoutData()).exclude = true;
            this.verticalScaleLabel.setVisible(false);
        }
        if (this.items.length != 0 && this.horizontalScaleVisible && !this.horizontalScaleCanvas.getVisible()) {
            ((GridData)this.horizontalScaleCanvas.getLayoutData()).exclude = false;
            this.horizontalScaleCanvas.setVisible(true);
            this.composite.layout();
        }
        if ((this.items.length == 0 || !this.horizontalScaleVisible) && this.horizontalScaleCanvas.getVisible()) {
            ((GridData)this.horizontalScaleCanvas.getLayoutData()).exclude = true;
            this.horizontalScaleCanvas.setVisible(false);
            this.composite.layout();
        }
    }

    public Display getDisplay() {
        return this.sashForm.getDisplay();
    }

    public boolean isDisposed() {
        return this.sashForm.isDisposed();
    }

    private void onPaintHorizontalScale(PaintEvent event) {
        block13: {
            Object[] elements;
            if (!(this.renderer instanceof IScaleRenderer)) {
                return;
            }
            Rectangle clientArea = this.horizontalScaleCanvas.getClientArea();
            ScrollBar hScroll = this.composite.getHorizontalBar();
            Object firstElement = this.horizontalAxis.mapToValue(hScroll != null ? hScroll.getSelection() : 0);
            Object lastElement = this.horizontalAxis.mapToValue((hScroll != null ? hScroll.getSelection() : 0) + clientArea.width);
            if (this.getInput() != null && this.needsRedraw && (elements = this.contentProvider.getElements(this.getInput())) != null && elements.length != 0) {
                RenderTarget graphics = new RenderTarget();
                try {
                    try {
                        Rectangle canvasArea = this.horizontalScaleCanvas.getClientArea();
                        if (this.horizontalScaleImage == null) {
                            this.horizontalScaleImage = new Image((Device)this.horizontalScaleCanvas.getDisplay(), canvasArea.width, canvasArea.height);
                        }
                        graphics.gc = new GC((Drawable)this.horizontalScaleImage);
                        graphics.display = this.horizontalScaleCanvas.getDisplay();
                        graphics.x = hScroll != null ? -hScroll.getSelection() : 0;
                        graphics.y = 0;
                        graphics.width = canvasArea.width;
                        graphics.height = canvasArea.height;
                        graphics.widget = this.horizontalScaleCanvas;
                        graphics.horizontalAxis = this.horizontalAxis;
                        graphics.verticalAxis = this.verticalAxis;
                        graphics.firstValue = new AdaptableWrapper(firstElement);
                        graphics.lastValue = new AdaptableWrapper(lastElement);
                        graphics.input = this.input;
                        graphics.gc.setAntialias(0);
                        graphics.gc.setForeground(this.horizontalScaleCanvas.getForeground());
                        graphics.gc.setBackground(this.horizontalScaleCanvas.getBackground());
                        ((IScaleRenderer)((Object)this.renderer)).renderHorizontalScale(graphics);
                    }
                    catch (Error error) {
                        Status status = new Status(4, "org.eclipsetrader.ui.charts", Messages.ChartViewer_HorizontalScaleRenderingError);
                        ChartsUIActivator.log((IStatus)status);
                        if (graphics.gc != null) {
                            graphics.gc.dispose();
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (graphics.gc != null) {
                        graphics.gc.dispose();
                    }
                    throw throwable;
                }
                if (graphics.gc != null) {
                    graphics.gc.dispose();
                }
            }
        }
        if (this.horizontalScaleImage != null && !this.horizontalScaleImage.isDisposed()) {
            event.gc.drawImage(this.horizontalScaleImage, 0, 0);
        } else {
            event.gc.setForeground(this.horizontalScaleCanvas.getForeground());
            event.gc.setBackground(this.horizontalScaleCanvas.getBackground());
            event.gc.fillRectangle(event.x, event.y, event.width, event.height);
        }
    }

    protected void updateScrollbars() {
        if (this.items != null && this.items.length != 0) {
            Point chartSize = new Point(0, 0);
            Rectangle clientArea = this.items[0].getCanvas().getClientArea();
            ScrollBar hScroll = this.composite.getHorizontalBar();
            boolean wasVisible = hScroll.getVisible();
            int i = 0;
            while (i < 2) {
                if (this.horizontalAxis != null) {
                    chartSize.x = this.horizontalAxis.computeSize(clientArea.width);
                    if (hScroll != null) {
                        if (chartSize.x > clientArea.width) {
                            hScroll.setVisible(true);
                        } else {
                            hScroll.setVisible(false);
                            hScroll.setValues(0, 0, 1, 1, 1, 1);
                        }
                    }
                }
                clientArea = this.items[0].getCanvas().getClientArea();
                ++i;
            }
            if (hScroll.getVisible()) {
                int hiddenArea = chartSize.x - clientArea.width + 1;
                int currentSelection = hScroll.getSelection();
                int rightAnchor = hScroll.getMaximum() - hScroll.getThumb();
                int selection = Math.min(currentSelection, hiddenArea - 1);
                if (!wasVisible || currentSelection == rightAnchor) {
                    selection = hiddenArea - 1;
                }
                hScroll.setValues(selection, 0, hiddenArea + clientArea.width - 1, clientArea.width, 5, clientArea.width);
            }
        }
    }

    private void onPaintItem(PaintEvent event) {
        ChartItem item = (ChartItem)event.widget.getData();
        Canvas canvas = item.getCanvas();
        Image image = item.getImage();
        boolean needsRedraw = Boolean.TRUE.equals(canvas.getData(K_NEEDS_REDRAW));
        Rectangle clientArea = canvas.getClientArea();
        ScrollBar hScroll = this.composite.getHorizontalBar();
        if (!(image == null || image.isDisposed() || image.getBounds().width == clientArea.width && image.getBounds().height == clientArea.height)) {
            image.dispose();
        }
        if (image == null || image.isDisposed()) {
            image = new Image((Device)canvas.getDisplay(), clientArea.width, clientArea.height);
            item.setImage(image);
            needsRedraw = true;
        }
        if (needsRedraw && image != null && !image.isDisposed()) {
            block17: {
                RenderTarget target = new RenderTarget();
                try {
                    try {
                        Object firstElement = this.horizontalAxis.mapToValue(hScroll.getSelection());
                        Object lastElement = this.horizontalAxis.mapToValue(hScroll.getSelection() + clientArea.width);
                        target.gc = new GC((Drawable)image);
                        target.display = event.display;
                        target.x = -hScroll.getSelection();
                        target.y = 0;
                        target.width = clientArea.width;
                        target.height = clientArea.height;
                        target.widget = event.widget;
                        target.horizontalAxis = this.horizontalAxis;
                        target.verticalAxis = this.verticalAxis;
                        target.input = item.getData();
                        target.firstValue = firstElement instanceof IAdaptable ? firstElement : new AdaptableWrapper(firstElement);
                        target.lastValue = lastElement instanceof IAdaptable ? lastElement : new AdaptableWrapper(lastElement);
                        target.gc.setForeground(canvas.getForeground());
                        target.gc.setBackground(canvas.getBackground());
                        IChartRenderer renderer = this.getRenderer();
                        renderer.renderBackground(target);
                        Object[] elements = this.getContentProvider().getChildren(item.getData());
                        if (elements != null) {
                            int i = 0;
                            while (i < elements.length) {
                                target.gc.setForeground(canvas.getForeground());
                                target.gc.setBackground(canvas.getBackground());
                                target.gc.setLineWidth(1);
                                renderer.renderElement(target, elements[i]);
                                ++i;
                            }
                        }
                    }
                    catch (Error error) {
                        Status status = new Status(4, "org.eclipsetrader.ui.charts", Messages.ChartViewer_RenderingErrorMessage);
                        ChartsUIActivator.log((IStatus)status);
                        if (target.gc != null) {
                            target.gc.dispose();
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (target.gc != null) {
                        target.gc.dispose();
                    }
                    throw throwable;
                }
                if (target.gc != null) {
                    target.gc.dispose();
                }
            }
            canvas.setData(K_NEEDS_REDRAW, (Object)Boolean.FALSE);
        }
        if (image != null && !image.isDisposed()) {
            int height;
            Rectangle bounds = image.getBounds();
            int width = event.width;
            if (event.x + width > bounds.width) {
                width = bounds.width - event.x;
            }
            if (event.y + (height = event.height) > bounds.height) {
                height = bounds.height - event.y;
            }
            if (width != 0 && height != 0) {
                event.gc.drawImage(image, event.x, event.y, width, height, event.x, event.y, width, height);
            }
        }
    }

    private void onPaintItemVerticalScale(PaintEvent event) {
        ChartItem item = (ChartItem)event.widget.getData();
        Canvas canvas = item.getVerticalScaleCanvas();
        Image image = item.getVerticalScaleImage();
        boolean needsRedraw = Boolean.TRUE.equals(canvas.getData(K_NEEDS_REDRAW));
        Rectangle clientArea = canvas.getClientArea();
        ScrollBar hScroll = this.composite.getHorizontalBar();
        if (!(image == null || image.isDisposed() || image.getBounds().width == clientArea.width && image.getBounds().height == clientArea.height)) {
            image.dispose();
        }
        if (image == null || image.isDisposed()) {
            image = new Image((Device)canvas.getDisplay(), clientArea.width, clientArea.height);
            item.setVerticalScaleImage(image);
            needsRedraw = true;
        }
        if (needsRedraw && image != null && !image.isDisposed()) {
            block15: {
                RenderTarget target = new RenderTarget();
                try {
                    try {
                        Object firstElement = this.horizontalAxis.mapToValue(hScroll.getSelection());
                        Object lastElement = this.horizontalAxis.mapToValue(hScroll.getSelection() + item.getCanvas().getClientArea().width);
                        target.gc = new GC((Drawable)image);
                        target.display = event.display;
                        target.x = -hScroll.getSelection();
                        target.y = 0;
                        target.width = clientArea.width;
                        target.height = clientArea.height;
                        target.widget = event.widget;
                        target.horizontalAxis = this.horizontalAxis;
                        target.verticalAxis = this.verticalAxis;
                        target.input = item.getData();
                        target.firstValue = firstElement instanceof IAdaptable ? firstElement : new AdaptableWrapper(firstElement);
                        target.lastValue = lastElement instanceof IAdaptable ? lastElement : new AdaptableWrapper(lastElement);
                        target.gc.setAntialias(0);
                        target.gc.setForeground(canvas.getForeground());
                        target.gc.setBackground(canvas.getBackground());
                        IScaleRenderer renderer = (IScaleRenderer)((Object)this.getRenderer());
                        renderer.renderVerticalScale(target);
                    }
                    catch (Error error) {
                        Status status = new Status(4, "org.eclipsetrader.ui.charts", Messages.ChartViewer_RenderingErrorMessage);
                        ChartsUIActivator.log((IStatus)status);
                        if (target.gc != null) {
                            target.gc.dispose();
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (target.gc != null) {
                        target.gc.dispose();
                    }
                    throw throwable;
                }
                if (target.gc != null) {
                    target.gc.dispose();
                }
            }
            canvas.setData(K_NEEDS_REDRAW, (Object)Boolean.FALSE);
        }
        if (image != null && !image.isDisposed()) {
            int height;
            Rectangle bounds = image.getBounds();
            int width = event.width;
            if (event.x + width > bounds.width) {
                width = bounds.width - event.x;
            }
            if (event.y + (height = event.height) > bounds.height) {
                height = bounds.height - event.y;
            }
            if (width != 0 && height != 0) {
                event.gc.drawImage(image, event.x, event.y, width, height, event.x, event.y, width, height);
            }
        }
    }

    public Control getControl() {
        return this.composite;
    }
}

