/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.util.UUID;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.ui.charts.ChartRowViewItem;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import pk.com.softech.tradingterminal.core.views.IViewItem;
import pk.com.softech.tradingterminal.core.views.IViewItemVisitor;

public class ChartViewItem
extends PlatformObject
implements IViewItem,
IWorkbenchAdapter {
    private ChartRowViewItem parent;
    private String id;
    private IChartObjectFactory factory;
    private IChartObject object;

    public ChartViewItem(ChartRowViewItem parent, IChartObjectFactory factory, String id) {
        this.parent = parent;
        this.factory = factory;
        this.id = id;
    }

    public ChartViewItem(ChartRowViewItem parent, IChartObjectFactory factory) {
        this.parent = parent;
        this.factory = factory;
        this.id = UUID.randomUUID().toString();
    }

    public String getId() {
        return this.id;
    }

    public int getItemCount() {
        return 0;
    }

    public IViewItem[] getItems() {
        return null;
    }

    public IViewItem getParent() {
        return this.parent;
    }

    public IAdaptable[] getValues() {
        return null;
    }

    public IChartObjectFactory getFactory() {
        return this.factory;
    }

    public IChartObject getObject() {
        if (this.object == null && this.factory != null) {
            this.object = this.factory.createObject(this.getSourceDataSeries());
        }
        return this.object;
    }

    public void setObject(IChartObject object) {
        this.object = object;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(IChartObject.class)) {
            if (this.object == null && this.factory != null) {
                this.object = this.factory.createObject(this.getSourceDataSeries());
            }
            return this.object;
        }
        if (this.object != null && adapter.isAssignableFrom(this.object.getClass())) {
            return this.object;
        }
        if (adapter.isAssignableFrom(IChartObjectFactory.class)) {
            return this.factory;
        }
        if (this.factory != null) {
            Object o;
            if (adapter.isAssignableFrom(this.factory.getClass())) {
                return this.factory;
            }
            if (this.factory instanceof IAdaptable && (o = ((IAdaptable)this.factory).getAdapter(adapter)) != null) {
                return o;
            }
        }
        if (adapter.isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public Object[] getChildren(Object o) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return this.factory.getName();
    }

    public Object getParent(Object o) {
        return null;
    }

    protected IDataSeries getSourceDataSeries() {
        IViewItem parentItem = this.getParent();
        while (parentItem != null) {
            IDataSeries dataSeries = (IDataSeries)parentItem.getAdapter(IDataSeries.class);
            if (dataSeries != null) {
                return dataSeries;
            }
            parentItem = parentItem.getParent();
        }
        return null;
    }

    public void accept(IViewItemVisitor visitor) {
        IViewItem[] child;
        if (visitor.visit((IViewItem)this) && (child = this.getItems()) != null) {
            int i = 0;
            while (i < child.length) {
                child[i].accept(visitor);
                ++i;
            }
        }
    }
}

