/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.RGB;
import org.eclipsetrader.core.charts.repository.IParameter;
import org.eclipsetrader.core.internal.charts.repository.Parameter;
import org.eclipsetrader.ui.charts.IChartParameters;

public class ChartParameters
implements IChartParameters {
    private Map<String, String> map = new HashMap<String, String>();
    private NumberFormat nf = NumberFormat.getInstance(Locale.US);
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ChartParameters() {
        this.nf.setMinimumFractionDigits(0);
    }

    @Override
    public String[] getParameterNames() {
        Set<String> c = this.map.keySet();
        return c.toArray(new String[c.size()]);
    }

    @Override
    public String getString(String name) {
        return this.map.get(name);
    }

    @Override
    public Integer getInteger(String name) {
        try {
            return this.map.containsKey(name) ? new Integer(this.nf.parse(this.map.get(name)).intValue()) : null;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public Double getDouble(String name) {
        try {
            return this.map.containsKey(name) ? new Double(this.nf.parse(this.map.get(name)).doubleValue()) : null;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public RGB getColor(String name) {
        String[] ar;
        String value = this.map.get(name);
        if (value != null && (ar = value.split(",")).length == 3) {
            return new RGB(Integer.parseInt(ar[0]), Integer.parseInt(ar[1]), Integer.parseInt(ar[2]));
        }
        return null;
    }

    @Override
    public boolean hasParameter(String name) {
        return this.map.containsKey(name);
    }

    @Override
    public void setParameter(String name, String value) {
        if (value != null) {
            this.map.put(name, value);
        } else {
            this.map.remove(name);
        }
    }

    @Override
    public void setParameter(String name, Number value) {
        if (value != null) {
            this.map.put(name, this.nf.format(value));
        } else {
            this.map.remove(name);
        }
    }

    @Override
    public void setParameter(String name, RGB value) {
        if (value != null) {
            this.map.put(name, String.valueOf(value.red) + "," + value.green + "," + value.blue);
        } else {
            this.map.remove(name);
        }
    }

    @Override
    public Date getDate(String name) {
        String s = this.map.get(name);
        if (s != null) {
            try {
                return this.dateFormat.parse(s);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    @Override
    public void setParameter(String name, Date value) {
        if (value != null) {
            this.map.put(name, this.dateFormat.format(value));
        } else {
            this.map.remove(name);
        }
    }

    public IParameter[] toParametersArray() {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (String name : this.map.keySet()) {
            params.add(new Parameter(name, this.map.get(name)));
        }
        return params.toArray(new IParameter[params.size()]);
    }
}

